/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.net.ftp.FTPFile;

public class FtpConsumer
extends RemoteFileConsumer<FTPFile> {
    protected String endpointPath;

    public FtpConsumer(RemoteFileEndpoint<FTPFile> endpoint, Processor processor, RemoteFileOperations<FTPFile> fileOperations) {
        super(endpoint, processor, fileOperations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected boolean pollDirectory(String fileName, List<GenericFile<FTPFile>> fileList, int depth) {
        String currentDir = null;
        if (this.isStepwise()) {
            currentDir = this.operations.getCurrentDirectory();
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        boolean answer = this.doPollDirectory(fileName, null, fileList, depth);
        if (currentDir != null) {
            this.operations.changeCurrentDirectory(currentDir);
        }
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList, int depth) {
        boolean answer = this.doPollDirectory(absolutePath, dirName, fileList, depth);
        if (this.isStepwise()) {
            this.operations.changeToParentDirectory();
        }
        return answer;
    }

    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList, int depth) {
        String dir;
        this.log.trace("doPollDirectory from absolutePath: {}, dirName: {}", (Object)absolutePath, (Object)dirName);
        ++depth;
        dirName = FileUtil.stripTrailingSeparator((String)dirName);
        if (this.isStepwise()) {
            dir = ObjectHelper.isNotEmpty((Object)dirName) ? dirName : absolutePath;
            this.operations.changeCurrentDirectory(dir);
        } else {
            dir = absolutePath;
        }
        this.log.trace("Polling directory: {}", (Object)dir);
        List files = this.isStepwise() ? this.operations.listFiles() : this.operations.listFiles(dir);
        if (files == null || files.isEmpty()) {
            this.log.trace("No files found in directory: {}", (Object)dir);
            return true;
        }
        this.log.trace("Found {} in directory: {}", (Object)files.size(), (Object)dir);
        for (FTPFile file : files) {
            RemoteFile<FTPFile> remote;
            if (this.log.isTraceEnabled()) {
                this.log.trace("FtpFile[name={}, dir={}, file={}]", new Object[]{file.getName(), file.isDirectory(), file.isFile()});
            }
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (file.isDirectory()) {
                remote = this.asRemoteFile(absolutePath, file);
                if (!this.endpoint.isRecursive() || !this.isValidFile(remote, true, files) || depth >= this.endpoint.getMaxDepth()) continue;
                String subDirectory = file.getName();
                String path = absolutePath + "/" + subDirectory;
                boolean canPollMore = this.pollSubDirectory(path, subDirectory, fileList, depth);
                if (canPollMore) continue;
                return false;
            }
            if (file.isFile()) {
                remote = this.asRemoteFile(absolutePath, file);
                if (!this.isValidFile(remote, false, files) || depth < this.endpoint.getMinDepth()) continue;
                if (this.isInProgress(remote)) {
                    this.log.trace("Skipping as file is already in progress: {}", (Object)remote.getFileName());
                    continue;
                }
                fileList.add(remote);
                continue;
            }
            this.log.debug("Ignoring unsupported remote file type: " + file);
        }
        return true;
    }

    protected boolean isMatched(GenericFile<FTPFile> file, String doneFileName, List<FTPFile> files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (FTPFile f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        this.log.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    private RemoteFile<FTPFile> asRemoteFile(String absolutePath, FTPFile file) {
        RemoteFile<FTPFile> answer = new RemoteFile<FTPFile>();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.getSize());
        answer.setDirectory(file.isDirectory());
        if (file.getTimestamp() != null) {
            answer.setLastModified(file.getTimestamp().getTimeInMillis());
        }
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        boolean absolute = FileUtil.hasLeadingSeparator((String)absolutePath);
        answer.setAbsolute(absolute);
        String dir = FileUtil.stripTrailingSeparator((String)absolutePath);
        String absoluteFileName = FileUtil.stripLeadingSeparator((String)(dir + "/" + file.getName()));
        if (absolute) {
            absoluteFileName = "/" + absoluteFileName;
        }
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }

    private boolean isStepwise() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isStepwise();
    }

    public String toString() {
        return "FtpConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

