/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import org.apache.camel.util.FileUtil;

public final class FtpUtils {
    private FtpUtils() {
    }

    public static String compactPath(String path) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf(File.separator) == -1) {
            return path;
        }
        boolean endsWithSlash = path.endsWith("/") || path.endsWith("\\");
        boolean startsWithSlash = path.startsWith("/") || path.startsWith("\\");
        Stack<String> stack = new Stack<String>();
        String separatorRegex = File.separator;
        if (FileUtil.isWindows()) {
            separatorRegex = "\\\\";
        }
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty() && !"..".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            if (part.equals(".") || part.isEmpty()) continue;
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        if (startsWithSlash) {
            sb.append(File.separator);
        }
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(File.separator);
        }
        if (endsWithSlash) {
            sb.append(File.separator);
        }
        if (sb.length() >= 2) {
            boolean secondSlash;
            boolean firstSlash = sb.charAt(0) == '/' || sb.charAt(0) == '\\';
            boolean bl = secondSlash = sb.charAt(1) == '/' || sb.charAt(1) == '\\';
            if (firstSlash && secondSlash) {
                sb = sb.replace(1, 2, "");
            }
        }
        return sb.toString();
    }
}

