/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.OverlayW3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SAAJStreamWriter
extends OverlayW3CDOMStreamWriter {
    private final SOAPPart part;

    public SAAJStreamWriter(SOAPPart part) {
        super((Document)part);
        this.part = part;
    }

    public SAAJStreamWriter(SOAPPart part, Element current) {
        super((Document)part, current);
        this.part = part;
    }

    private SOAPElement adjustPrefix(SOAPElement e, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            String s = e.getPrefix();
            if (!prefix.equals(s)) {
                e.setPrefix(prefix);
                e.removeNamespaceDeclaration(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return e;
    }

    @Override
    protected void adjustOverlaidNode(Node nd2, String pfx) {
        String namespace = nd2.getNamespaceURI();
        try {
            if (namespace != null && namespace.equals(this.part.getEnvelope().getElementName().getURI())) {
                this.adjustPrefix((SOAPElement)nd2, pfx);
            }
        }
        catch (SOAPException e) {
            // empty catch block
        }
        super.adjustOverlaidNode(nd2, pfx);
    }

    @Override
    protected void createAndAddElement(String prefix, String local, String namespace) {
        try {
            if (namespace != null && namespace.equals(this.part.getEnvelope().getElementName().getURI())) {
                if ("Envelope".equals(local)) {
                    this.setChild((Element)this.adjustPrefix((SOAPElement)this.part.getEnvelope(), prefix), false);
                    this.adjustPrefix((SOAPElement)this.part.getEnvelope().getHeader(), prefix);
                    return;
                }
                if ("Body".equals(local)) {
                    this.setChild((Element)this.adjustPrefix((SOAPElement)this.part.getEnvelope().getBody(), prefix), false);
                    return;
                }
                if ("Header".equals(local)) {
                    if (this.part.getEnvelope().getHeader() == null) {
                        this.part.getEnvelope().addHeader();
                    }
                    this.setChild((Element)this.adjustPrefix((SOAPElement)this.part.getEnvelope().getHeader(), prefix), false);
                    return;
                }
                if ("Fault".equals(local)) {
                    SOAPFault f = this.part.getEnvelope().getBody().getFault();
                    if (f == null) {
                        Element el = this.part.createElementNS(namespace, StringUtils.isEmpty(prefix) ? local : prefix + ":" + local);
                        this.part.getEnvelope().getBody().appendChild((Node)el);
                        f = this.part.getEnvelope().getBody().getFault();
                        if (f == null) {
                            f = this.part.getEnvelope().getBody().addFault();
                        }
                    }
                    this.setChild((Element)this.adjustPrefix((SOAPElement)f, prefix), false);
                    return;
                }
            } else if (this.getCurrentNode() instanceof SOAPFault) {
                SOAPFault f = (SOAPFault)this.getCurrentNode();
                for (Node nd = f.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                    if (!(nd instanceof Element)) continue;
                    Element el = (Element)nd;
                    if (!local.equals(nd.getLocalName())) continue;
                    this.setChild(el, false);
                    nd = el.getFirstChild();
                    while (nd != null) {
                        el.removeChild(nd);
                        nd = el.getFirstChild();
                    }
                    return;
                }
            }
        }
        catch (SOAPException e) {
            // empty catch block
        }
        super.createAndAddElement(prefix, local, namespace);
    }
}

