/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;

public class EffectivePolicyImpl
implements EffectivePolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EffectivePolicyImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(EffectivePolicyImpl.class);
    protected Policy policy;
    protected Collection<Assertion> chosenAlternative;
    protected List<Interceptor<? extends Message>> interceptors;

    @Override
    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public List<Interceptor<? extends Message>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Collection<Assertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    public void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine, boolean inbound) {
        this.initialise(epi, engine, inbound, false);
    }

    public void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine, boolean inbound, boolean fault) {
        this.policy = epi.getPolicy();
        this.chosenAlternative = epi.getChosenAlternative();
        if (this.chosenAlternative == null) {
            this.chooseAlternative(engine, null);
        }
        this.initialiseInterceptors(engine, inbound, fault);
    }

    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor, boolean request) {
        this.initialisePolicy(ei, boi, engine, requestor, request, assertor);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
    }

    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor, boolean request, List<List<Assertion>> incoming) {
        this.initialisePolicy(ei, boi, engine, requestor, request, assertor);
        this.chooseAlternative(engine, assertor, incoming);
        this.initialiseInterceptors(engine, false);
    }

    public void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request) {
        Assertor assertor = this.initialisePolicy(ei, boi, engine, requestor, request, null);
        if (requestor || !request) {
            this.chooseAlternative(engine, assertor);
            this.initialiseInterceptors(engine, requestor);
        } else {
            Collection<Assertion> alternative = engine.getAssertions((PolicyComponent)this.policy, true);
            this.setChosenAlternative(alternative);
        }
    }

    public void initialise(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, PolicyEngineImpl engine, Assertor assertor) {
        this.initialisePolicy(ei, boi, bfi, engine);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
    }

    private <T> T getAssertorAs(Assertor as, Class<T> t) {
        org.apache.cxf.transport.Assertor o;
        if (t.isInstance(as)) {
            return t.cast(as);
        }
        if (as instanceof PolicyUtils.WrappedAssertor && t.isInstance(o = ((PolicyUtils.WrappedAssertor)as).getWrappedAssertor())) {
            return t.cast(o);
        }
        return null;
    }

    Assertor initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request, Assertor assertor) {
        if (boi.isUnwrapped()) {
            boi = boi.getUnwrappedOperation();
        }
        BindingMessageInfo bmi = request ? boi.getInput() : boi.getOutput();
        EndpointPolicy ep = requestor ? engine.getClientEndpointPolicy(ei, this.getAssertorAs(assertor, Conduit.class)) : engine.getServerEndpointPolicy(ei, this.getAssertorAs(assertor, Destination.class));
        this.policy = ep.getPolicy();
        if (ep instanceof EndpointPolicyImpl) {
            assertor = ((EndpointPolicyImpl)ep).getAssertor();
        }
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (null != bmi) {
            this.policy = this.policy.merge(engine.getAggregatedMessagePolicy(bmi));
        }
        this.policy = this.policy.normalize(engine.getRegistry(), true);
        return assertor;
    }

    void initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, PolicyEngineImpl engine) {
        this.policy = engine.getServerEndpointPolicy(ei, null).getPolicy();
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (bfi != null) {
            this.policy = this.policy.merge(engine.getAggregatedFaultPolicy(bfi));
        }
        this.policy = this.policy.normalize(engine.getRegistry(), true);
    }

    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor) {
        this.chooseAlternative(engine, assertor, null);
    }

    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor, List<List<Assertion>> incoming) {
        Collection<Assertion> alternative = engine.getAlternativeSelector().selectAlternative(this.policy, engine, assertor, incoming);
        if (null == alternative) {
            PolicyUtils.logPolicy(LOG, Level.FINE, "No alternative supported.", (PolicyComponent)this.getPolicy());
            throw new PolicyException(new org.apache.cxf.common.i18n.Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    void initialiseInterceptors(PolicyEngineImpl engine) {
        this.initialiseInterceptors(engine, false);
    }

    void initialiseInterceptors(PolicyEngineImpl engine, boolean useIn) {
        this.initialiseInterceptors(engine, useIn, false);
    }

    void initialiseInterceptors(PolicyEngineImpl engine, boolean useIn, boolean fault) {
        if (engine.getBus() != null) {
            PolicyInterceptorProviderRegistry reg = engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
            LinkedHashSet<Interceptor<? extends Message>> out = new LinkedHashSet<Interceptor<? extends Message>>();
            for (Assertion a : this.getChosenAlternative()) {
                this.initialiseInterceptors(reg, engine, out, a, useIn, fault);
            }
            this.setInterceptors(new ArrayList<Interceptor<? extends Message>>(out));
        }
    }

    protected Collection<Assertion> getSupportedAlternatives(PolicyEngineImpl engine, Policy p) {
        ArrayList<Assertion> alternatives = new ArrayList<Assertion>();
        Iterator it = p.getAlternatives();
        while (it.hasNext()) {
            List alternative = (List)it.next();
            if (!engine.supportsAlternative(alternative, null)) continue;
            alternatives.addAll(alternative);
        }
        return alternatives;
    }

    void initialiseInterceptors(PolicyInterceptorProviderRegistry reg, PolicyEngineImpl engine, Set<Interceptor<? extends Message>> out, Assertion a, boolean useIn, boolean fault) {
        Policy p;
        QName qn = a.getName();
        List<Interceptor<? extends Message>> i = null;
        if (useIn && !fault) {
            i = reg.getInInterceptorsForAssertion(qn);
        } else if (!useIn && !fault) {
            i = reg.getOutInterceptorsForAssertion(qn);
        } else if (useIn && fault) {
            i = reg.getInFaultInterceptorsForAssertion(qn);
        } else if (!useIn && fault) {
            i = reg.getOutFaultInterceptorsForAssertion(qn);
        }
        out.addAll(i);
        if (a instanceof PolicyContainingAssertion && (p = ((PolicyContainingAssertion)a).getPolicy()) != null) {
            for (Assertion a2 : this.getSupportedAlternatives(engine, p)) {
                this.initialiseInterceptors(reg, engine, out, a2, useIn, fault);
            }
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<Assertion> c) {
        this.chosenAlternative = c;
    }

    void setInterceptors(List<Interceptor<? extends Message>> out) {
        this.interceptors = out;
    }
}

