/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.myfaces.shared_impl.resource.AliasResourceMetaImpl;
import org.apache.myfaces.shared_impl.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared_impl.resource.ResourceLoader;
import org.apache.myfaces.shared_impl.resource.ResourceLoaderUtils;
import org.apache.myfaces.shared_impl.resource.ResourceMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends Resource {
    private ResourceMeta _resourceMeta;
    private ResourceLoader _resourceLoader;
    private ResourceHandlerSupport _resourceHandlerSupport;

    public ResourceImpl(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceHandlerSupport support, String contentType) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public ResourceLoader getResourceLoader() {
        return this._resourceLoader;
    }

    public InputStream getInputStream() throws IOException {
        if (this.couldResourceContainValueExpressions()) {
            return new ValueExpressionFilterInputStream(this.getResourceLoader().getResourceInputStream(this._resourceMeta));
        }
        return this.getResourceLoader().getResourceInputStream(this._resourceMeta);
    }

    private boolean couldResourceContainValueExpressions() {
        if (this._resourceMeta.couldResourceContainValueExpressions()) {
            return true;
        }
        String contentType = this.getContentType();
        return "text/css".equals(contentType);
    }

    public String getRequestPath() {
        String path;
        if (this._resourceHandlerSupport.isExtensionMapping()) {
            path = "/javax.faces.resource/" + this.getResourceName() + this._resourceHandlerSupport.getMapping();
        } else {
            String mapping = this._resourceHandlerSupport.getMapping();
            path = "/javax.faces.resource/" + this.getResourceName();
            path = mapping == null ? path : mapping + path;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String metadata = null;
        boolean useAmp = false;
        if (this.getLibraryName() != null) {
            metadata = "?ln=" + this.getLibraryName();
            path = path + metadata;
            useAmp = true;
            if (!facesContext.isProjectStage(ProjectStage.Production) && "jsf.js".equals(this.getResourceName()) && "javax.faces".equals(this.getLibraryName())) {
                path = path + "&stage=" + facesContext.getApplication().getProjectStage().toString();
            }
        }
        return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
    }

    public Map<String, String> getResponseHeaders() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext)) {
            long lastModified;
            HashMap<String, String> headers = new HashMap<String, String>();
            try {
                lastModified = ResourceLoaderUtils.getResourceLastModified(this.getURL());
            }
            catch (IOException e) {
                lastModified = -1L;
            }
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            } else if (this._resourceMeta instanceof AliasResourceMetaImpl && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified >= 0L) {
                headers.put("Last-Modified", ResourceLoaderUtils.formatDateHeader(lastModified));
                long expires = facesContext.isProjectStage(ProjectStage.Development) ? System.currentTimeMillis() : System.currentTimeMillis() + this._resourceHandlerSupport.getMaxTimeExpires();
                headers.put("Expires", ResourceLoaderUtils.formatDateHeader(expires));
            }
            return headers;
        }
        return Collections.emptyMap();
    }

    public URL getURL() {
        return this.getResourceLoader().getResourceURL(this._resourceMeta);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        Long lastModified;
        String ifModifiedSinceString = (String)context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since");
        if (ifModifiedSinceString == null) {
            return true;
        }
        Long ifModifiedSince = ResourceLoaderUtils.parseDateHeader(ifModifiedSinceString);
        if (ifModifiedSince == null) {
            return true;
        }
        try {
            lastModified = ResourceLoaderUtils.getResourceLastModified(this.getURL());
        }
        catch (IOException exception) {
            lastModified = -1L;
        }
        if (lastModified >= 0L) {
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified - lastModified % 1000L <= ifModifiedSince) {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueExpressionFilterInputStream
    extends InputStream {
        private PushbackInputStream delegate;

        public ValueExpressionFilterInputStream(InputStream in) {
            this.delegate = new PushbackInputStream(in, 255);
        }

        @Override
        public int read() throws IOException {
            int c1 = this.delegate.read();
            if (c1 == -1) {
                return -1;
            }
            if ((char)c1 == '#') {
                int c2 = this.delegate.read();
                if (c2 == -1) {
                    return -1;
                }
                if ((char)c2 == '{') {
                    ArrayList<Integer> expressionList = new ArrayList<Integer>();
                    int c3 = this.delegate.read();
                    while (c3 != -1 && (char)c3 != '}') {
                        expressionList.add(c3);
                        c3 = this.delegate.read();
                    }
                    if (c3 == -1) {
                        for (int i = 0; i < expressionList.size(); ++i) {
                            this.delegate.unread((Integer)expressionList.get(i));
                        }
                        this.delegate.unread(c2);
                        return c1;
                    }
                    FacesContext context = FacesContext.getCurrentInstance();
                    ELContext elContext = context.getELContext();
                    try {
                        ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + this.convertToExpression(expressionList) + "}", String.class);
                        String value = (String)ve.getValue(elContext);
                        for (int i = value.length() - 1; i >= 0; --i) {
                            this.delegate.unread(value.charAt(i));
                        }
                    }
                    catch (ELException e) {
                        ExceptionQueuedEventContext equecontext = new ExceptionQueuedEventContext(context, (Throwable)e, null);
                        context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)equecontext);
                        Logger log = Logger.getLogger(ResourceImpl.class.getName());
                        if (log.isLoggable(Level.SEVERE)) {
                            log.severe("Cannot evaluate EL expression " + this.convertToExpression(expressionList) + " in resource " + ResourceImpl.this.getLibraryName() + ":" + ResourceImpl.this.getResourceName());
                        }
                        this.delegate.unread(c3);
                        for (int i = expressionList.size() - 1; i >= 0; --i) {
                            this.delegate.unread((Integer)expressionList.get(i));
                        }
                        this.delegate.unread(c2);
                        return c1;
                    }
                    return this.delegate.read();
                }
                this.delegate.unread(c2);
                return c1;
            }
            return c1;
        }

        private String convertToExpression(List<Integer> expressionList) {
            char[] exprArray = new char[expressionList.size()];
            for (int i = 0; i < expressionList.size(); ++i) {
                exprArray[i] = (char)expressionList.get(i).intValue();
            }
            return String.valueOf(exprArray);
        }
    }
}

