/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;

public final class ComponentSupport {
    private static final String MARK_DELETED = "org.apache.myfaces.view.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "org.apache.myfaces.view.facelets.MARK_ID";
    public static final String FACET_CREATED_UIPANEL_MARKER = "org.apache.myfaces.facet.createdUIPanel";

    @Deprecated
    public static void finalizeForDeletion(UIComponent component) {
        Map facets;
        component.getAttributes().remove(MARK_DELETED);
        if (component.getChildCount() > 0) {
            Iterator iter = component.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                if (!child.getAttributes().containsKey(MARK_DELETED)) continue;
                iter.remove();
            }
        }
        if (!(facets = component.getFacets()).isEmpty()) {
            Collection col = facets.values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_DELETED)) continue;
                itr.remove();
            }
        }
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        if (parent.getChildCount() > 0) {
            for (UIComponent child : parent.getChildren()) {
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public static UIComponent findChildByTagId(UIComponent parent, String id) {
        for (UIComponent child : parent.getChildren()) {
            if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
            return child;
        }
        for (UIComponent facet : parent.getFacets().values()) {
            if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                Iterator itr2 = facet.getFacetsAndChildren();
                while (itr2.hasNext()) {
                    UIComponent child = (UIComponent)itr2.next();
                    if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                    return child;
                }
                continue;
            }
            if (!id.equals(facet.getAttributes().get(MARK_CREATED))) continue;
            return facet;
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    @Deprecated
    public static void markForDeletion(UIComponent component) {
        component.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (!child.getAttributes().containsKey(MARK_CREATED)) continue;
            child.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent toRender) throws IOException, FacesException {
        if (toRender.isRendered()) {
            toRender.encodeBegin(context);
            if (toRender.getRendersChildren()) {
                toRender.encodeChildren(context);
            } else if (toRender.getChildCount() > 0) {
                for (UIComponent child : toRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, child);
                }
            }
            toRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent component) {
        Map facets;
        if (component.getChildCount() > 0) {
            Iterator itr = component.getChildren().iterator();
            while (itr.hasNext()) {
                UIComponent child = (UIComponent)itr.next();
                if (child.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(child);
            }
        }
        if (!(facets = component.getFacets()).isEmpty()) {
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent facet = (UIComponent)itr.next();
                if (facet.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(facet);
            }
        }
    }

    @Deprecated
    public static boolean isNew(UIComponent component) {
        return component != null && component.getParent() == null;
    }

    private static UIComponent createFacetUIPanel(FacesContext facesContext) {
        UIComponent panel = facesContext.getApplication().createComponent("javax.faces.Panel");
        panel.setId(facesContext.getViewRoot().createUniqueId());
        panel.getAttributes().put(FACET_CREATED_UIPANEL_MARKER, Boolean.TRUE);
        return panel;
    }

    public static void addFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = (UIComponent)parent.getFacets().get(facetName);
        if (facet == null) {
            parent.getFacets().put(facetName, c);
        } else if (!(facet instanceof UIPanel)) {
            UIComponent child = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx.getFacesContext());
            facet.getChildren().add(child);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        } else if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().add(c);
        } else {
            UIComponent oldPanel = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx.getFacesContext());
            facet.getChildren().add(oldPanel);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        }
    }

    public static void removeFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = parent.getFacet(facetName);
        if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().remove(c);
        } else {
            parent.getFacets().remove(facetName);
        }
    }

    public static void markComponentToRestoreFully(FacesContext context, UIComponent component) {
        if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isRefreshTransientBuildOnPSSPreserveState()) {
            component.getAttributes().put("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW", ComponentState.REMOVE_ADD);
        }
        if (FaceletViewDeclarationLanguage.isRefreshTransientBuildOnPSSAuto(context)) {
            FaceletViewDeclarationLanguage.cleanTransientBuildOnRestore(context);
        }
    }
}

