/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseMapping
implements Cloneable,
Serializable {
    protected static final Vector NO_FIELDS = NonSynchronizedVector.newInstance(0);
    protected static final Integer NO_WEIGHT = new Integer(Integer.MAX_VALUE);
    protected static final Integer WEIGHT_1 = new Integer(1);
    protected ClassDescriptor descriptor;
    protected AttributeAccessor attributeAccessor;
    protected boolean isReadOnly = false;
    protected boolean isOptional = true;
    protected Boolean isLazy;
    protected Vector<DatabaseField> fields;
    protected boolean isRemotelyInitialized;
    protected Integer weight = NO_WEIGHT;
    protected Map properties;
    protected boolean isPrimaryKeyMapping = false;
    protected String attributeName;

    public DatabaseMapping() {
        this.attributeAccessor = new InstanceVariableAttributeAccessor();
    }

    public abstract void buildBackupClone(Object var1, Object var2, UnitOfWorkImpl var3);

    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupCloneForPartObject");
    }

    public abstract void buildClone(Object var1, Object var2, UnitOfWorkImpl var3);

    public abstract void buildCloneFromRow(AbstractRecord var1, JoinedAttributeManager var2, Object var3, ObjectBuildingQuery var4, UnitOfWorkImpl var5, AbstractSession var6);

    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
    }

    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneForPartObject");
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
    }

    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        return null;
    }

    public Expression buildObjectJoinExpression(Expression base, Object value, AbstractSession session) {
        throw QueryException.unsupportedMappingForObjectComparison(this, base);
    }

    public Expression buildObjectJoinExpression(Expression base, Expression argument, AbstractSession session) {
        throw QueryException.unsupportedMappingForObjectComparison(this, base);
    }

    public abstract void cascadePerformRemoveIfRequired(Object var1, UnitOfWorkImpl var2, Map var3);

    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public abstract void cascadeRegisterNewIfRequired(Object var1, UnitOfWorkImpl var2, Map var3);

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
    }

    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "calculatedDeferredChanges");
    }

    public void cascadeMerge(Object sourceElement, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "cascadeMerge");
    }

    public Object clone() {
        DatabaseMapping mapping = null;
        try {
            mapping = (DatabaseMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        mapping.setAttributeAccessor((AttributeAccessor)this.attributeAccessor.clone());
        return mapping;
    }

    protected Vector cloneFields(Vector fields) {
        NonSynchronizedVector clonedFields = NonSynchronizedVector.newInstance();
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ((Vector)clonedFields).addElement(((DatabaseField)fieldsEnum.nextElement()).clone());
        }
        return clonedFields;
    }

    protected Vector<DatabaseField> collectFields() {
        return NO_FIELDS;
    }

    public abstract org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object var1, Object var2, ObjectChangeSet var3, AbstractSession var4);

    public abstract boolean compareObjects(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        throw DescriptorException.invalidMappingOperation(this, "createUnitOfWorkValueHolder");
    }

    protected Vector extractNestedExpressions(List expressions, ExpressionBuilder newRoot, boolean rootExpressionsAllowed) {
        NonSynchronizedVector nestedExpressions = NonSynchronizedVector.newInstance(expressions.size());
        for (Expression next : expressions) {
            QueryKeyExpression expression;
            if (!next.isQueryKeyExpression()) continue;
            QueryKeyExpression base = expression = (QueryKeyExpression)next;
            boolean afterBase = false;
            while (!base.getBaseExpression().isExpressionBuilder()) {
                afterBase = true;
                base = (QueryKeyExpression)base.getBaseExpression();
            }
            if (afterBase && base.getName().equals(this.getAttributeName())) {
                ((Vector)nestedExpressions).addElement(expression.rebuildOn(base, newRoot));
                continue;
            }
            if (!rootExpressionsAllowed || !expression.getBaseExpression().isExpressionBuilder() || !expression.getName().equals(this.getAttributeName())) continue;
            ((Vector)nestedExpressions).addElement(newRoot);
        }
        return nestedExpressions;
    }

    protected boolean hasRootExpressionThatShouldUseOuterJoin(List expressions) {
        for (Expression next : expressions) {
            QueryKeyExpression expression;
            if (!next.isQueryKeyExpression() || !(expression = (QueryKeyExpression)next).getBaseExpression().isExpressionBuilder() || !expression.getName().equals(this.getAttributeName())) continue;
            return expression.shouldUseOuterJoin();
        }
        return false;
    }

    public abstract void fixObjectReferences(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, RemoteSession var5);

    public void fixRealObjectReferences(Object object, Map objectInformation, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
    }

    public AttributeAccessor getAttributeAccessor() {
        return this.attributeAccessor;
    }

    public Class getAttributeClassification() {
        return null;
    }

    public String getAttributeName() {
        if (this.attributeName == null) {
            this.attributeName = this.getAttributeAccessor().getAttributeName();
        }
        return this.attributeName;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return this.attributeAccessor.getAttributeValueFromObject(object);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public ContainerPolicy getContainerPolicy() {
        throw DescriptorException.invalidMappingOperation(this, "getContainerPolicy");
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseField getField() {
        return null;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) {
        return null;
    }

    public Vector getSelectFields() {
        return this.getFields();
    }

    public Vector getSelectTables() {
        return new NonSynchronizedVector(0);
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public String getGetMethodName() {
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodName();
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return object;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(Object property) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(property);
    }

    public Object getRealAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        return this.getRealAttributeValueFromAttribute(this.getAttributeValueFromObject(object), object, session);
    }

    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) throws DescriptorException {
        return attributeValue;
    }

    public void instantiateAttribute(Object object, AbstractSession session) {
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "getRealCollectionAttributeValueFromObject");
    }

    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public String getSetMethodName() {
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodName();
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        throw DescriptorException.invalidMappingOperation(this, "getValueFromRemoteValueHolder");
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasConstraintDependency() {
        return false;
    }

    public boolean isUsingMethodAccess() {
        return this.getAttributeAccessor().isMethodAttributeAccessor();
    }

    public boolean hasDependency() {
        return this.isPrivateOwned();
    }

    public boolean hasInverseConstraintDependency() {
        return false;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
    }

    public boolean isAggregateCollectionMapping() {
        return false;
    }

    public boolean isAggregateMapping() {
        return false;
    }

    public boolean isAggregateObjectMapping() {
        return false;
    }

    public boolean isCollectionMapping() {
        return false;
    }

    public boolean isDatabaseMapping() {
        return true;
    }

    public boolean isDirectCollectionMapping() {
        return false;
    }

    public boolean isDirectMapMapping() {
        return false;
    }

    public boolean isDirectToFieldMapping() {
        return false;
    }

    public boolean isForeignReferenceMapping() {
        return false;
    }

    public boolean isManyToManyMapping() {
        return false;
    }

    public boolean isNestedTableMapping() {
        return false;
    }

    public boolean isObjectReferenceMapping() {
        return false;
    }

    public boolean isOneToManyMapping() {
        return false;
    }

    public boolean isOneToOneMapping() {
        return false;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isLazy() {
        if (this.isLazy == null) {
            this.isLazy = Boolean.FALSE;
        }
        return this.isLazy;
    }

    public void setIsLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public boolean isEISMapping() {
        return false;
    }

    public boolean isRelationalMapping() {
        return false;
    }

    public boolean isXMLMapping() {
        return false;
    }

    public boolean isAbstractDirectMapping() {
        return false;
    }

    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    public boolean isAbstractCompositeObjectMapping() {
        return false;
    }

    public boolean isAbstractCompositeCollectionMapping() {
        return false;
    }

    public boolean isJoiningSupported() {
        return false;
    }

    public boolean isCloningRequired() {
        return true;
    }

    public boolean isPrimaryKeyMapping() {
        return this.isPrimaryKeyMapping;
    }

    public boolean isCandidateForPrivateOwnedRemoval() {
        return this.isPrivateOwned();
    }

    public boolean isCascadedLockingSupported() {
        return false;
    }

    public boolean isChangeTrackingSupported(Project project) {
        return false;
    }

    public boolean isPrivateOwned() {
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isReferenceMapping() {
        return false;
    }

    protected boolean isRemotelyInitialized() {
        return this.isRemotelyInitialized;
    }

    public boolean isStructureMapping() {
        return false;
    }

    public boolean isTransformationMapping() {
        return false;
    }

    public boolean isUnidirectionalOneToManyMapping() {
        return false;
    }

    public boolean isVariableOneToOneMapping() {
        return false;
    }

    public boolean isDirectToXMLTypeMapping() {
        return false;
    }

    public boolean isWriteOnly() {
        return false;
    }

    public abstract void iterate(DescriptorIterator var1);

    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        throw DescriptorException.invalidMappingOperation(this, "iterateOnRealAttributeValue");
    }

    public abstract void mergeChangesIntoObject(Object var1, org.eclipse.persistence.internal.sessions.ChangeRecord var2, Object var3, MergeManager var4);

    public abstract void mergeIntoObject(Object var1, boolean var2, Object var3, MergeManager var4);

    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        throw DescriptorException.invalidDataModificationEvent(this);
    }

    public void postDelete(DeleteObjectQuery query) throws DatabaseException {
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        try {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            session.getIntegrityChecker().handleError(exception);
        }
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException {
    }

    public void prepareCascadeLockingPolicy() {
    }

    public void preUpdate(WriteObjectQuery query) throws DatabaseException {
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(targetObject, attributeValue);
        return attributeValue;
    }

    public Object readFromResultSetIntoObject(ResultSet resultSet, Object targetObject, ObjectBuildingQuery query, AbstractSession session, DatabaseAccessor accessor, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform) throws DatabaseException {
        Object attributeValue = this.valueFromResultSet(resultSet, query, session, accessor, metaData, columnNumber, platform);
        this.setAttributeValueInObject(targetObject, attributeValue);
        return attributeValue;
    }

    public void readOnly() {
        this.setIsReadOnly(true);
    }

    public void readWrite() {
        this.setIsReadOnly(false);
    }

    public void rehashFieldDependancies(AbstractSession session) {
    }

    public void remoteInitialization(DistributedSession session) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    protected void remotelyInitialized() {
        this.isRemotelyInitialized = true;
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    public void setAttributeAccessor(AttributeAccessor attributeAccessor) {
        String attributeName = this.getAttributeName();
        this.attributeAccessor = attributeAccessor;
        if (attributeAccessor.getAttributeName() == null) {
            attributeAccessor.setAttributeName(attributeName);
        }
        this.attributeName = null;
    }

    public void setAttributeName(String attributeName) {
        this.getAttributeAccessor().setAttributeName(attributeName);
        this.attributeName = null;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        try {
            this.attributeAccessor.setAttributeValueInObject(object, value);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        try {
            this.setAttributeValueInObject(object, value);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setGetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            String attributeName = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setGetMethodName(methodName);
    }

    public void setIsOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public void setIsPrimaryKeyMapping(boolean isPrimaryKeyMapping) {
        this.isPrimaryKeyMapping = isPrimaryKeyMapping;
    }

    public void setIsReadOnly(boolean aBoolean) {
        this.isReadOnly = aBoolean;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(Object property, Object value) {
        this.getProperties().put(property, value);
    }

    public void setSetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (!this.getAttributeAccessor().isMethodAttributeAccessor()) {
            String attributeName = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setSetMethodName(methodName);
    }

    public void setWeight(Integer newWeight) {
        this.weight = newWeight;
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleAddToCollectionChangeRecord");
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleRemoveFromCollectionChangeRecord");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "]";
    }

    public void validateAfterInitialization(AbstractSession session) throws DescriptorException {
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
    }

    public Object valueFromObject(Object anObject, DatabaseField field, AbstractSession session) {
        return null;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query) throws DatabaseException {
        return this.valueFromRow(row, joinManager, query, query.getExecutionSession());
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) throws DatabaseException {
        return null;
    }

    public Object valueFromResultSet(ResultSet resultSet, ObjectBuildingQuery query, AbstractSession session, DatabaseAccessor accessor, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform) throws DatabaseException {
        throw DescriptorException.invalidMappingOperation(this, "valueFromResultSet");
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        return true;
    }

    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord row, AbstractSession session) {
        this.writeFromObjectIntoRow(object, row, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        this.writeFromObjectIntoRowWithChangeRecord(changeRecord, row, session);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord row) {
        this.writeFromObjectIntoRow(query.getObject(), row, query.getSession());
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery query, AbstractRecord row) {
        Object object = query.isDeleteObjectQuery() ? query.getObject() : query.getBackupClone();
        this.writeFromObjectIntoRow(object, row, query.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
    }

    public void writeUpdateFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        this.writeInsertFieldsIntoRow(databaseRow, session);
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "updateChangeRecord");
    }

    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "updateCollectionChangeRecord");
    }

    public void setChangeListener(Object clone, PropertyChangeListener listener, UnitOfWorkImpl uow) {
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }

    public org.eclipse.persistence.internal.sessions.ChangeRecord buildChangeRecord(Object newValue, ObjectChangeSet owner, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "buildChangeRecord");
    }

    public void postCalculateChanges(ChangeRecord changeRecord, AbstractSession session) {
    }

    public void postCalculateChangesOnDeleted(Object object, UnitOfWorkChangeSet changeSet, AbstractSession session) {
    }
}

