/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.base;

import javax.management.ObjectName;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.base.JAXWSServiceMBean;
import org.ow2.jonas.ws.jaxws.base.audit.JaxwsClientAuditHandler;
import org.ow2.jonas.ws.jaxws.base.audit.JaxwsEndpointAuditHandler;
import org.ow2.jonas.ws.jaxws.base.audit.mbean.AuditHandlerAdapter;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JAXWSService
extends AbsServiceImpl
implements IJAXWSService,
JAXWSServiceMBean {
    private static Log logger = LogFactory.getLog(JAXWSService.class);
    private static final String OBJECTNAME_BASE = ":type=Auditors,auditorType=";
    private JmxService jmxService = null;
    private JaxwsClientAuditHandler clientHandler;
    private JaxwsEndpointAuditHandler serverHandler;
    private IEventService eventService = null;

    protected void doStart() throws ServiceException {
        try {
            this.jmxService.registerMBean((Object)this, JonasObjectName.jaxwsService((String)this.getDomainName()));
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot register MBean for JAX-WS service", new Object[]{e});
        }
        this.jmxService.loadDescriptors(AuditHandlerAdapter.class.getPackage().getName(), AuditHandlerAdapter.class.getClassLoader());
    }

    protected void doStop() throws ServiceException {
        if (this.jmxService != null) {
            try {
                this.jmxService.unregisterMBean(JonasObjectName.jaxwsService((String)this.getDomainName()));
            }
            catch (Exception e) {
                logger.debug((Object)"Cannot unregister MBean for JAX-WS service", new Object[]{e});
            }
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    protected JmxService getJmxService() {
        return this.jmxService;
    }

    public void setEventService(IEventService eventService) {
        this.eventService = eventService;
    }

    public SOAPHandler<SOAPMessageContext> getClientAuditHandler() {
        if (this.clientHandler == null) {
            this.clientHandler = new JaxwsClientAuditHandler(CurrentInvocationID.getInstance());
            try {
                ObjectName name = new ObjectName(this.jmxService.getDomainName() + OBJECTNAME_BASE + "wsclient");
                this.jmxService.registerModelMBean((Object)this.clientHandler, name);
            }
            catch (Exception e) {
                logger.debug((Object)"Cannot register MBean for JAX-WS Client Audit Handler", new Object[]{e});
            }
        }
        return this.clientHandler;
    }

    public SOAPHandler<SOAPMessageContext> getEndpointAuditHandler() {
        if (this.serverHandler == null) {
            this.serverHandler = new JaxwsEndpointAuditHandler(CurrentInvocationID.getInstance(), this.eventService);
            try {
                ObjectName name = new ObjectName(this.jmxService.getDomainName() + OBJECTNAME_BASE + "wsendpoint");
                this.jmxService.registerModelMBean((Object)this.serverHandler, name);
            }
            catch (Exception e) {
                logger.debug((Object)"Cannot register MBean for JAX-WS Endpoint Audit Handler", new Object[]{e});
            }
        }
        return this.serverHandler;
    }
}

