/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NullComparisonExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasNot;
    private String isIdentifier;
    private String notIdentifier;
    private String nullIdentifier;

    public NullComparisonExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.updateExpression(expression);
    }

    public NullComparisonExpression(AbstractExpression parent, String identifier, AbstractExpression expression) {
        super(parent, identifier);
        this.updateExpression(expression);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.hasExpression()) {
            children.add(this.expression);
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression(this.getIdentifier()));
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.expression == expression) {
            return expression.getQueryBNF();
        }
        return super.findQueryBNF(expression);
    }

    public String getActualIsIdentifier() {
        return this.isIdentifier != null ? this.isIdentifier : "";
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public String getActualNullIdentifier() {
        return this.nullIdentifier;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.hasNot ? "IS NOT NULL" : "IS NULL";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("null_comparison_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.isIdentifier = wordParser.moveForward("IS");
        wordParser.skipLeadingWhitespace();
        this.hasNot = wordParser.startsWithIdentifier("NOT");
        if (this.hasNot) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        this.nullIdentifier = wordParser.moveForward("NULL");
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (actual) {
            writer.append(this.isIdentifier);
            writer.append(' ');
            if (this.hasNot) {
                writer.append(this.notIdentifier);
                writer.append(' ');
            }
            writer.append(this.nullIdentifier);
        } else {
            writer.append(this.getIdentifier());
        }
    }

    private void updateExpression(AbstractExpression expression) {
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }
}

