/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.eclipselink.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.jpa.Archive;
import org.ow2.easybeans.persistence.eclipselink.deployment.BundleArchive;
import org.ow2.easybeans.persistence.eclipselink.deployment.EasyBeansDirectoryArchive;
import org.ow2.easybeans.persistence.eclipselink.deployment.EasyBeansJarFileArchive;

public class EasyBeansArchiveFactoryImpl
extends ArchiveFactoryImpl {
    private Logger logger;

    public EasyBeansArchiveFactoryImpl() {
        this(Logger.global);
    }

    public EasyBeansArchiveFactoryImpl(Logger logger) {
        super(logger);
        this.logger = logger;
    }

    public Archive createArchive(URL rootUrl, String descriptorLocation, Map properties) throws URISyntaxException, IOException {
        this.logger.entering("EasyBeansArchiveFactoryImpl", "createArchive", new Object[]{rootUrl, descriptorLocation});
        String protocol = rootUrl.getProtocol();
        this.logger.logp(Level.FINER, "EasyBeansArchiveFactoryImpl", "createArchive", "protocol = {0}", protocol);
        if ("bundle".equals(protocol) || "bundleentry".equals(protocol)) {
            return new BundleArchive(rootUrl, descriptorLocation);
        }
        if ("file".equals(protocol)) {
            File f;
            URI uri = Helper.toURI(rootUrl);
            try {
                f = new File(uri);
            }
            catch (IllegalArgumentException e) {
                f = new File(rootUrl.getPath());
            }
            if (f.isDirectory()) {
                return new EasyBeansDirectoryArchive(f, descriptorLocation);
            }
            return new EasyBeansJarFileArchive(rootUrl, new JarFile(f), descriptorLocation);
        }
        return super.createArchive(rootUrl, descriptorLocation, properties);
    }
}

