/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.config;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Map;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public abstract class AuthConfigFactory {
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";
    private static AuthConfigFactory theFactory;
    private static SecurityPermission readPermission;
    private static SecurityPermission writePermission;

    public static synchronized AuthConfigFactory getFactory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(readPermission);
        }
        if (theFactory == null) {
            String className;
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(writePermission);
            }
            if ((className = Security.getProperty(DEFAULT_FACTORY_SECURITY_PROPERTY)) != null) {
                try {
                    theFactory = (AuthConfigFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        private static final long serialVersionUID = -1419974841166638995L;

                        public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            Class<?> clazz = Class.forName(className, true, cl);
                            return (AuthConfigFactory)clazz.newInstance();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getCause() instanceof ClassNotFoundException) {
                        throw (SecurityException)new SecurityException().initCause(new AuthException(AuthConfigFactory.class.getName() + ": Could not find the AuthConfigFactory" + " implementation class '" + className + "'"));
                    }
                    if (pae.getCause() instanceof InstantiationException) {
                        throw (SecurityException)new SecurityException().initCause(new AuthException(AuthConfigFactory.class.getName() + ": Could not instantiate the AuthConfigFactory" + " instance with zero-argument constructor of" + " class '" + className + "'"));
                    }
                    if (pae.getCause() instanceof IllegalAccessException) {
                        throw (SecurityException)new SecurityException().initCause(new AuthException(AuthConfigFactory.class.getName() + ": Could not access the AuthConfigFactory" + " class '" + className + "' or its" + " zero-argument constructor"));
                    }
                    throw (SecurityException)new SecurityException().initCause((AuthException)new AuthException("Unexpected exception happened while instantiating the AuthConfigFactory").initCause(pae));
                }
            }
        }
        return theFactory;
    }

    public static synchronized void setFactory(AuthConfigFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(writePermission);
        }
        theFactory = factory;
    }

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract String registerConfigProvider(String var1, Map var2, String var3, String var4, String var5);

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract boolean removeRegistration(String var1);

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract void refresh();

    static {
        readPermission = new SecurityPermission("getProperty.authconfigprovider.factory");
        writePermission = new SecurityPermission("setProperty.authconfigprovider.factory");
    }

    public static interface RegistrationContext {
        public String getMessageLayer();

        public String getAppContext();

        public String getDescription();

        public boolean isPersistent();
    }
}

