/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityLocal;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JWrapper;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.naming.ComponentContext;

public class JStatefulOutputStream
extends ObjectOutputStream {
    protected JStatefulOutputStream(OutputStream out) throws IOException {
        super(out);
        this.enableReplaceObject(true);
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        Object ret;
        if (obj instanceof EJBObject) {
            ret = ((EJBObject)obj).getHandle();
        } else if (obj instanceof EJBHome) {
            ret = ((EJBHome)obj).getHomeHandle();
        } else if (obj instanceof JEntityLocal) {
            JEntityLocal local = (JEntityLocal)obj;
            ret = local.getJWrapper();
        } else if (obj instanceof JLocalHome) {
            JLocalHome lhome = (JLocalHome)obj;
            String jndiname = lhome.getJndiLocalName();
            ret = new JWrapper(4, jndiname);
        } else if (obj instanceof ComponentContext) {
            try {
                String cname = ((Context)obj).getNameInNamespace();
                ret = new JWrapper(6, cname);
            }
            catch (NamingException e) {
                TraceEjb.ssfpool.log(BasicLevel.ERROR, (Object)("Cannot convert Context: " + e));
                ret = obj;
            }
        } else if (obj instanceof UserTransaction) {
            ret = new JWrapper(1, null);
        } else if (obj instanceof SessionContext) {
            ret = new JWrapper(2, null);
        } else if (obj instanceof Handle) {
            Handle theHandle = (Handle)obj;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(theHandle);
            byte[] ser = baos.toByteArray();
            ret = new JWrapper(3, ser);
        } else if (obj instanceof Remote && !(obj instanceof RemoteStub)) {
            Remote remote = (Remote)obj;
            try {
                ret = RemoteObject.toStub(remote);
            }
            catch (IOException ignore) {
                TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Cannot convert to stub");
                ret = obj;
            }
        } else {
            if (TraceEjb.isDebugSsfpool()) {
                TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("Other:" + obj));
            }
            ret = obj;
        }
        return ret;
    }
}

