/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.TraceEjb;

class Swapper
extends Thread {
    private JContainer container;
    private boolean valid = true;
    private LinkedList bfsList = new LinkedList();
    private static final long SYNC_TIMEOUT = 30000L;
    private static final long MIN_SWAP_TIMEOUT = 60000L;
    private static final long MAX_SWAP_TIMEOUT = 900000L;
    private long swapTimeout = 900000L;
    private long nextSync;
    private boolean waiting;

    public Swapper(JContainer cont) {
        super("JonasSwapper-" + cont.getName());
        this.container = cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.valid) {
            BeanFactory bfs = null;
            Swapper swapper = this;
            synchronized (swapper) {
                if (this.bfsList.size() == 0) {
                    try {
                        this.waiting = true;
                        this.wait(this.swapTimeout);
                        this.waiting = false;
                    }
                    catch (InterruptedException e) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.getName() + ": swapper interrupted"), (Throwable)e);
                    }
                    catch (Exception e) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.getName() + ": swapper exception"), (Throwable)e);
                    }
                }
                try {
                    bfs = (BeanFactory)this.bfsList.removeFirst();
                }
                catch (NoSuchElementException e) {
                    bfs = null;
                }
            }
            if (bfs != null) {
                bfs.syncDirty(true);
            }
            if (System.currentTimeMillis() < this.nextSync) continue;
            this.container.syncAll(false, true);
            this.nextSync = System.currentTimeMillis() + this.swapTimeout;
        }
    }

    public synchronized void stopIt() {
        this.valid = false;
        this.notify();
    }

    public synchronized void addBeanFactorySync(BeanFactory bf) {
        if (!this.bfsList.contains(bf)) {
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("" + this.bfsList.size()));
            }
            this.bfsList.addLast(bf);
            this.notify();
        }
    }

    public synchronized void addBeanFactory(BeanFactory bf) {
        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)"");
        long curtime = System.currentTimeMillis();
        if (curtime >= this.nextSync) {
            if (this.waiting) {
                this.notify();
            }
        } else if (this.nextSync - curtime > 30000L) {
            this.nextSync = 30000L;
        }
    }

    public synchronized void setSwapperTimeout(int t) {
        long ms = (long)t * 1000L;
        if (ms < this.swapTimeout && ms >= 60000L) {
            this.swapTimeout = ms;
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("" + t));
        }
        this.notify();
    }
}

