/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon.mbean;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jonas.cluster.daemon.ClusterDaemon;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteException;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerHelper;

public final class JMXRemoteHelper {
    private static JMXConnectorServer jmxConnectorServer = null;
    private static final String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jonasConnector";
    private static final String DEFAULT_NAME_CONNECTOR = "connectors:name=JMXRemoteConnector";
    private static MBeanServerConnection mbscnx = null;

    private JMXRemoteHelper() {
    }

    private static void init(String url, Map env) throws JMXRemoteException {
        HashMap<String, String> environment = new HashMap<String, String>();
        JMXServiceURL jmxServiceURL = null;
        try {
            jmxServiceURL = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new JMXRemoteException("Cannot create jmxservice url with url '" + url + "'.", e);
        }
        environment.put("jmx.remote.jndi.rebind", "true");
        if (env != null) {
            environment.putAll(env);
        }
        try {
            jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, environment, null);
        }
        catch (IOException e) {
            throw new JMXRemoteException("Cannot create new JMX Connector", e);
        }
    }

    public static MBeanServerConnection connect(String url) throws JMXRemoteException {
        return JMXRemoteHelper.connect(url, null, null);
    }

    public static MBeanServerConnection connect(String url, String username, String password) throws JMXRemoteException {
        if (mbscnx != null) {
            return mbscnx;
        }
        JMXServiceURL jmxServiceURL = null;
        try {
            jmxServiceURL = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new JMXRemoteException("Cannot create jmxservice url with url '" + url + "'.", e);
        }
        try {
            HashMap<String, String[]> env = null;
            if (username != null && password != null) {
                env = new HashMap<String, String[]>(1);
                String[] creds = new String[]{username, password};
                env.put("jmx.remote.credentials", creds);
            }
            JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL, env);
            mbscnx = jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new JMXRemoteException("Cannot connect to JMX remote with '" + url + "'.", e);
        }
        return mbscnx;
    }

    public static synchronized void startConnector(String url, String connectorName) throws JMXRemoteException {
        JMXRemoteHelper.startConnector(url, connectorName, null);
    }

    public static synchronized JMXConnectorServer startConnector(String url, String connectorName, Map<String, String> env) throws JMXRemoteException {
        if (jmxConnectorServer == null) {
            if (url == null) {
                JMXRemoteHelper.init(DEFAULT_URL, env);
            } else {
                JMXRemoteHelper.init(url, env);
            }
        }
        ObjectName connectorServerName = null;
        String objName = null;
        try {
            objName = connectorName == null ? DEFAULT_NAME_CONNECTOR : connectorName;
            connectorServerName = new ObjectName(objName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXRemoteException("Cannot create ObjectName with name '" + objName + "'", e);
        }
        catch (NullPointerException e) {
            throw new JMXRemoteException("Cannot create ObjectName with name '" + objName + "'", e);
        }
        try {
            MBeanServerHelper.getMBeanServer().registerMBean(jmxConnectorServer, connectorServerName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        catch (MBeanRegistrationException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClusterDaemon.class.getClassLoader());
            jmxConnectorServer.start();
        }
        catch (IOException e) {
            throw new JMXRemoteException("Cannot start the jmx connector", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
        return jmxConnectorServer;
    }

    public static ObjectInstance getInstance(MBeanServerConnection cnx, String pattern) {
        Set<ObjectInstance> oiset = null;
        ObjectInstance oi = null;
        try {
            ObjectName on = new ObjectName(pattern);
            oiset = cnx.queryMBeans(on, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!oiset.isEmpty()) {
            oi = (ObjectInstance)oiset.iterator().next();
        }
        return oi;
    }
}

