/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Destructible;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.cfg.SearchConfigurationFromHibernateCore;
import org.hibernate.search.engine.AbstractDocumentBuilder;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.event.CoreComputedDirtyStrategy;
import org.hibernate.search.event.DirtyStrategy;
import org.hibernate.search.event.HSearchComputedDirtyStrategy;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ReflectionHelper;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
Initializable,
Destructible {
    private static final Logger log = LoggerFactory.make();
    private final Installation installation;
    protected boolean used;
    protected boolean skipDirtyChecks = true;
    protected SearchFactoryImplementor searchFactoryImplementor;
    private final DirtyStrategy dirtyStrategy;
    private final transient Map<Session, Synchronization> flushSynch = new WeakIdentityHashMap<Session, Synchronization>(0);

    public FullTextIndexEventListener() {
        String msg = "FullTextIndexEventListener default constructor is obsolete. Remove all explicitevent listener configuration. As of Hibernate Core 3.6 Hibernate Search will be automatically enabled if it is detected on the classpath.";
        log.error(msg);
        throw new SearchException(msg);
    }

    public FullTextIndexEventListener(Installation installation) {
        DirtyStrategy dirtyStrategy;
        this.installation = installation;
        try {
            PostUpdateEvent.class.getMethod("getDirtyProperties", new Class[0]);
            dirtyStrategy = new CoreComputedDirtyStrategy();
        }
        catch (NoSuchMethodException e) {
            dirtyStrategy = new HSearchComputedDirtyStrategy();
        }
        this.dirtyStrategy = dirtyStrategy;
    }

    @Override
    public void initialize(Configuration cfg) {
        String indexingStrategy;
        if (this.installation != Installation.SINGLE_INSTANCE) {
            throw new SearchException("Only Installation.SINGLE_INSTANCE is supported");
        }
        if (this.searchFactoryImplementor == null) {
            this.searchFactoryImplementor = new SearchFactoryBuilder().configuration(new SearchConfigurationFromHibernateCore(cfg)).buildSearchFactory();
        }
        if ("event".equals(indexingStrategy = this.searchFactoryImplementor.getIndexingStrategy())) {
            this.used = this.searchFactoryImplementor.getDocumentBuildersIndexedEntities().size() != 0;
        } else if ("manual".equals(indexingStrategy)) {
            this.used = false;
        }
        log.debug("Hibernate Search event listeners " + (this.used ? "activated" : "deactivated"));
        this.skipDirtyChecks = !this.searchFactoryImplementor.isDirtyChecksEnabled();
        log.debug("Hibernate Search dirty checks " + (this.skipDirtyChecks ? "disabled" : "enabled"));
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        Object entity;
        if (this.used && this.getDocumentBuilder(entity = event.getEntity()) != null) {
            boolean identifierRollbackEnabled = event.getSession().getFactory().getSettings().isIdentifierRollbackEnabled();
            this.processWork(entity, event.getId(), WorkType.DELETE, event, identifierRollbackEnabled);
        }
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        if (this.used && this.getDocumentBuilder(entity = event.getEntity()) != null) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.ADD, event, false);
        }
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        AbstractDocumentBuilder docBuilder;
        if (this.used && (docBuilder = this.getDocumentBuilder(entity = event.getEntity())) != null && (this.skipDirtyChecks || docBuilder.isDirty(this.dirtyStrategy.getDirtyPropertyNames(event)))) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.UPDATE, event, false);
        }
    }

    protected <T> void processWork(T entity, Serializable id, WorkType workType, AbstractEvent event, boolean identifierRollbackEnabled) {
        Work<T> work = new Work<T>(entity, id, workType, identifierRollbackEnabled);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.searchFactoryImplementor.getWorker().performWork(work, transactionContext);
    }

    @Override
    public void cleanup() {
        this.searchFactoryImplementor.close();
    }

    @Override
    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent(event);
    }

    @Override
    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent(event);
    }

    @Override
    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent(event);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        if (this.used) {
            String collectionRole;
            Object entity = event.getAffectedOwnerOrNull();
            if (entity == null) {
                return;
            }
            PersistentCollection persistentCollection = event.getCollection();
            if (persistentCollection != null) {
                if (!persistentCollection.wasInitialized()) {
                    return;
                }
                collectionRole = persistentCollection.getRole();
            } else {
                collectionRole = null;
            }
            AbstractDocumentBuilder documentBuilder = this.getDocumentBuilder(entity);
            if (documentBuilder != null && !documentBuilder.isCollectionRoleExcluded(collectionRole)) {
                Serializable id = this.getId(entity, event);
                if (id == null) {
                    log.warn("Unable to reindex entity on collection change, id cannot be extracted: {}", (Object)event.getAffectedOwnerEntityName());
                    return;
                }
                this.processWork(entity, id, WorkType.COLLECTION, event, false);
            }
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    @Override
    public void onFlush(FlushEvent event) {
        EventSource session;
        Synchronization synchronization;
        if (this.used && (synchronization = this.flushSynch.get(session = event.getSession())) != null) {
            this.flushSynch.remove(session);
            log.debug("flush event causing index update out of transaction");
            synchronization.beforeCompletion();
            synchronization.afterCompletion(3);
        }
    }

    public void addSynchronization(EventSource eventSource, Synchronization synchronization) {
        this.flushSynch.put(eventSource, synchronization);
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        is.defaultReadObject();
        Class<FullTextIndexEventListener> cl = FullTextIndexEventListener.class;
        Field f = cl.getDeclaredField("flushSynch");
        ReflectionHelper.setAccessible(f);
        WeakIdentityHashMap flushSynch = new WeakIdentityHashMap(0);
        f.set(this, flushSynch);
    }

    private AbstractDocumentBuilder getDocumentBuilder(Object entity) {
        Class<?> clazz = entity.getClass();
        DocumentBuilderIndexedEntity<?> documentBuilderIndexedEntity = this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (documentBuilderIndexedEntity != null) {
            return documentBuilderIndexedEntity;
        }
        return this.searchFactoryImplementor.getDocumentBuilderContainedEntity(clazz);
    }

    static {
        Version.touch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Installation {
        SINGLE_INSTANCE,
        MULTIPLE_INSTANCE;

    }
}

