/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.Calendar;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.ow2.easybeans.component.quartz.ScheduleValue;
import org.ow2.easybeans.component.quartz.ValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleValueRange
extends ScheduleValue {
    private String left;
    private String right;

    public ScheduleValueRange(String left, String right, int calendarField) {
        super(calendarField);
        this.left = left;
        this.right = right;
    }

    public NavigableSet<Integer> getValues(Calendar afterTimeCalendar) {
        int start = 0;
        int end = 0;
        String[] leftNDays = this.getNDays(this.left);
        String[] rightNDays = this.getNDays(this.right);
        if ("*".equals(this.left)) {
            start = afterTimeCalendar.getActualMaximum(this.getCalendarField());
        } else if ("last".equals(this.left)) {
            start = afterTimeCalendar.getActualMaximum(this.getCalendarField());
        } else if (leftNDays != null) {
            Integer dayStart = this.computeNDays(leftNDays[0], leftNDays[1], afterTimeCalendar);
            if (dayStart == null) {
                return null;
            }
            start = dayStart;
        } else {
            start = Integer.parseInt(this.left);
        }
        if ("*".equals(this.right)) {
            end = afterTimeCalendar.getActualMaximum(this.getCalendarField());
        } else if ("last".equals(this.right)) {
            end = afterTimeCalendar.getActualMaximum(this.getCalendarField());
        } else if (rightNDays != null) {
            Integer dayEnd = this.computeNDays(rightNDays[0], rightNDays[1], afterTimeCalendar);
            if (dayEnd == null) {
                return null;
            }
            end = dayEnd;
        } else {
            end = Integer.parseInt(this.right);
        }
        if (7 == this.getCalendarField()) {
            if (++start > 7) {
                start = 1;
            }
            if (++end > 7) {
                end = 1;
            }
        }
        TreeSet<Integer> allValues = new TreeSet<Integer>();
        if (start > end) {
            int leftStart = start;
            int leftEnd = afterTimeCalendar.getActualMaximum(this.getCalendarField());
            for (int i = leftStart; i <= leftEnd; ++i) {
                allValues.add(i);
            }
            int rightStart = afterTimeCalendar.getActualMinimum(this.getCalendarField());
            int rightEnd = end;
            for (int i = rightStart; i <= rightEnd; ++i) {
                allValues.add(i);
            }
        } else {
            for (int i = start; i <= end; ++i) {
                allValues.add(i);
            }
        }
        return allValues;
    }

    @Override
    public ValueResult getTimeAfter(Calendar afterTimeCalendar) {
        Integer foundValue;
        int currentFieldValue = afterTimeCalendar.get(this.getCalendarField());
        NavigableSet<Integer> allValues = this.getValues(afterTimeCalendar);
        ValueResult valueResult = new ValueResult();
        if (allValues == null) {
            valueResult.setResult(afterTimeCalendar.get(this.getCalendarField()));
            valueResult.setNeedsIncrement(true);
        }
        if ((foundValue = allValues.ceiling(currentFieldValue)) != null) {
            valueResult.setResult(foundValue);
        } else {
            valueResult.setResult((Integer)allValues.first());
            valueResult.setNeedsIncrement(true);
        }
        return valueResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[range : ");
        sb.append(this.left);
        sb.append(" - ");
        sb.append(this.right);
        sb.append("]");
        return sb.toString();
    }
}

