/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimerTask;
import org.objectweb.joram.mom.dest.AcquisitionDaemon;
import org.objectweb.joram.mom.dest.AcquisitionHandler;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.ReliableTransmitter;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AcquisitionModule
implements ReliableTransmitter {
    public static Logger logger = Debug.getLogger((String)AcquisitionModule.class.getName());
    public static final String PERIOD = "acquisition.period";
    public static final String CLASS_NAME = "acquisition.className";
    public static final String PERSISTENT_PROPERTY = "persistent";
    public static final String EXPIRATION_PROPERTY = "expiration";
    public static final String PRIORITY_PROPERTY = "priority";
    protected Object acquisitionHandler;
    private int priority;
    private boolean isPrioritySet;
    private boolean isPersistent;
    private boolean isPersistencySet;
    private long expiration;
    private boolean isExpirationSet;
    private final Destination destination;
    private long period;
    private AcquisitionTask acquisitionTask;
    private static volatile long transmitCounter = 0L;
    private boolean isDaemon = false;
    private boolean running;

    public static void checkAcquisitionClass(String className) throws Exception {
        if (className == null) {
            throw new Exception("AcquisitionHandler class not defined: use acquisition.className property to chose acquisition class.");
        }
        boolean isDaemon = false;
        boolean isHandler = false;
        for (Class<?> clazz = Class.forName(className); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals(AcquisitionDaemon.class)) {
                    isDaemon = true;
                    continue;
                }
                if (!interfaces[i].equals(AcquisitionHandler.class)) continue;
                isHandler = true;
            }
        }
        if (isDaemon && isHandler) {
            throw new Exception("Acquisition class " + className + " can't implement both AcquisitionHandler and AcquisitionDaemon interfaces.");
        }
        if (!isDaemon && !isHandler) {
            throw new Exception("Acquisition class " + className + " must implement either AcquisitionHandler or AcquisitionDaemon interface.");
        }
    }

    private static Properties transform(fr.dyade.aaa.common.stream.Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties prop = new Properties();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            prop.setProperty(key, properties.get(key).toString());
        }
        return prop;
    }

    public AcquisitionModule(Destination destination, String className, Properties properties) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.<init> prop = " + properties));
        }
        this.destination = destination;
        try {
            Class<?> clazz = Class.forName(className);
            this.acquisitionHandler = clazz.newInstance();
            if (this.acquisitionHandler instanceof AcquisitionDaemon) {
                this.isDaemon = true;
            }
            this.setProperties(properties);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't create acquisition handler.", (Throwable)exc);
        }
    }

    public boolean isMessagePersistent() {
        return this.isPersistent;
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public static long getCount() {
        return transmitCounter;
    }

    public void setProperties(Properties properties) {
        if (this.isDaemon && this.running) {
            ((AcquisitionDaemon)this.acquisitionHandler).stop();
            this.running = false;
        }
        if (this.acquisitionTask != null) {
            this.acquisitionTask.cancel();
        }
        this.period = 0L;
        this.isExpirationSet = false;
        this.isPersistencySet = false;
        this.isPrioritySet = false;
        Properties props = (Properties)properties.clone();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.setProperties = " + props + " daemon = " + this.isDaemon));
        }
        if (props.containsKey(PERIOD)) {
            try {
                this.period = ConversionHelper.toLong((Object)props.get(PERIOD));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined period property.");
            }
        }
        if (!this.isDaemon && this.period > 0L) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("schedule acquisition every " + this.period + "ms."));
            }
            this.acquisitionTask = new AcquisitionTask();
            AgentServer.getTimer().schedule((TimerTask)this.acquisitionTask, this.period, this.period);
        }
        if (props.containsKey(PERSISTENT_PROPERTY)) {
            try {
                this.isPersistent = ConversionHelper.toBoolean((Object)props.get(PERSISTENT_PROPERTY));
                this.isPersistencySet = true;
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message persistence property.");
                props.remove(PERSISTENT_PROPERTY);
            }
        }
        if (props.containsKey(PRIORITY_PROPERTY)) {
            try {
                this.priority = ConversionHelper.toInt((Object)props.get(PRIORITY_PROPERTY));
                this.isPrioritySet = true;
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message priority property.");
            }
        }
        if (props.containsKey(EXPIRATION_PROPERTY)) {
            try {
                this.expiration = ConversionHelper.toLong((Object)props.get(EXPIRATION_PROPERTY));
                this.isExpirationSet = true;
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message expiration property.");
            }
        }
        if (props.containsKey(CLASS_NAME) && !props.get(CLASS_NAME).equals(this.acquisitionHandler.getClass().getName())) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: Changing dynamically the acquisition class is not allowed.");
            props.remove(CLASS_NAME);
        }
        if (this.isDaemon) {
            ((AcquisitionDaemon)this.acquisitionHandler).start(props, this);
            this.running = true;
        } else {
            ((AcquisitionHandler)this.acquisitionHandler).setProperties(props);
        }
    }

    public void processMessages(ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.processMessages(" + (Object)((Object)cm) + ')'));
        }
        if (this.isDaemon || this.period > 0L) {
            DMQManager dmqManager = new DMQManager(this.destination.getDMQAgentId(), this.destination.getId());
            Iterator msgs = cm.getMessages().iterator();
            while (msgs.hasNext()) {
                dmqManager.addDeadMessage((Message)msgs.next(), (short)8);
            }
            dmqManager.sendToDMQ();
            return;
        }
        for (Message msg : cm.getMessages()) {
            if (msg.properties != null) {
                Properties msgProperties = AcquisitionModule.transform(msg.properties);
                ((AcquisitionHandler)this.acquisitionHandler).setProperties(msgProperties);
            }
            AgentServer.getTimer().schedule((TimerTask)new AcquisitionTask(), 0L);
        }
    }

    public Properties startHandler(Properties prop) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.startHandler(" + prop + ')'));
        }
        if (this.isDaemon && !this.running) {
            ((AcquisitionDaemon)this.acquisitionHandler).start(prop, this);
            this.running = true;
        }
        return null;
    }

    protected Properties stopHandler(Properties prop) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.stopHandler(" + prop + ')'));
        }
        if (this.isDaemon && this.running) {
            ((AcquisitionDaemon)this.acquisitionHandler).stop();
            this.running = false;
        }
        return null;
    }

    public ClientMessages acquisitionNot(AcquisitionNot not, long msgCount) {
        ClientMessages acquiredCM;
        List messages;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.acquisitionNot(" + (Object)((Object)not) + ")"));
        }
        if ((messages = (acquiredCM = not.getAcquiredMessages()).getMessages()).size() == 0) {
            return null;
        }
        this.setMessagesInfo(messages, msgCount);
        return acquiredCM;
    }

    private void setMessagesInfo(List messages, long msgCount) {
        long currentTime = System.currentTimeMillis();
        for (Message message : messages) {
            message.id = "ID:" + this.destination.getDestinationId() + '_' + msgCount;
            message.setDestination(this.destination.getId().toString(), this.destination.getType());
            if (message.timestamp == 0L) {
                message.timestamp = currentTime;
            }
            if (this.isExpirationSet) {
                message.expiration = this.expiration > 0L ? currentTime + this.expiration : 0L;
            }
            if (this.isPrioritySet) {
                message.priority = this.priority;
            }
            if (this.isPersistencySet) {
                message.persistent = this.isPersistent;
            }
            ++msgCount;
        }
    }

    public void close() {
        if (this.isDaemon && this.running) {
            ((AcquisitionDaemon)this.acquisitionHandler).stop();
            this.running = false;
        } else {
            if (this.acquisitionTask != null) {
                this.acquisitionTask.cancel();
            }
            ((AcquisitionHandler)this.acquisitionHandler).close();
        }
    }

    public void transmit(Message message, String messageId) {
        if (message != null) {
            ++transmitCounter;
            Channel.sendTo((AgentId)this.destination.getId(), (Notification)new AcquisitionNot(new ClientMessages(-1, -1, message), message.persistent, messageId));
        }
    }

    public void transmit(List messages, boolean persistent) {
        if (messages != null && messages.size() > 0) {
            ++transmitCounter;
            Channel.sendTo((AgentId)this.destination.getId(), (Notification)new AcquisitionNot(new ClientMessages(-1, -1, messages), persistent, null));
        }
    }

    public long getPeriod() {
        return this.period;
    }

    class AcquisitionTask
    extends TimerTask {
        AcquisitionTask() {
        }

        public void run() {
            try {
                ((AcquisitionHandler)AcquisitionModule.this.acquisitionHandler).retrieve(AcquisitionModule.this);
            }
            catch (Throwable exc) {
                logger.log(BasicLevel.ERROR, (Object)"Error while doing acquisition.", exc);
            }
        }
    }
}

