/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DistributionDaemon;
import org.objectweb.joram.mom.dest.DistributionModule;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionQueue
extends Queue {
    public static Logger logger = Debug.getLogger((String)DistributionQueue.class.getName());
    public static final long DEFAULT_PERIOD = 1000L;
    public static final String BATCH_DISTRIBUTION_OPTION = "distribution.batch";
    public static final String ASYNC_DISTRIBUTION_OPTION = "distribution.async";
    private static final long serialVersionUID = 1L;
    private transient DistributionModule distributionModule;
    private transient DistributionDaemon distributionDaemon;
    private String distributionClassName;
    private boolean batchDistribution;
    private boolean isAsyncDistribution;
    private Properties properties;

    public DistributionQueue() {
        this.fixed = true;
    }

    public void setProperties(Properties properties, boolean firstTime) throws Exception {
        super.setProperties(properties, firstTime);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.setProperties prop = " + properties));
        }
        this.properties = properties;
        this.batchDistribution = false;
        this.isAsyncDistribution = false;
        if (properties != null) {
            if (properties.containsKey(BATCH_DISTRIBUTION_OPTION)) {
                try {
                    this.batchDistribution = ConversionHelper.toBoolean((Object)properties.get(BATCH_DISTRIBUTION_OPTION));
                }
                catch (MessageValueException exc) {
                    logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't parse batch option.", (Throwable)exc);
                }
            }
            this.isAsyncDistribution = this.isAsyncDistribution(properties);
            if (this.isAsyncDistribution) {
                this.batchDistribution = true;
            }
        }
        if (firstTime) {
            if (properties != null) {
                this.distributionClassName = properties.getProperty("distribution.className");
                properties.remove("distribution.className");
            }
            if (this.distributionClassName == null) {
                throw new RequestException("Distribution class name not found: distribution.className property must be set on queue creation.");
            }
            try {
                Class.forName(this.distributionClassName).getConstructor(new Class[0]);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionQueue: error with distribution class.", (Throwable)exc);
                throw new RequestException(exc.getMessage());
            }
        }
        this.distributionModule.setProperties(properties, firstTime);
        if (this.distributionDaemon == null && this.isAsyncDistribution) {
            this.distributionDaemon = new DistributionDaemon(this.distributionModule.getDistributionHandler(), this.getName(), this);
            this.distributionDaemon.start();
        } else if (this.distributionDaemon != null && !this.isAsyncDistribution) {
            this.distributionDaemon.close();
            this.distributionDaemon = null;
            if (properties.containsKey(BATCH_DISTRIBUTION_OPTION)) {
                try {
                    this.batchDistribution = ConversionHelper.toBoolean((Object)properties.get(BATCH_DISTRIBUTION_OPTION));
                }
                catch (MessageValueException exc) {
                    logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't parse batch option.", (Throwable)exc);
                }
            }
        }
    }

    private boolean isAsyncDistribution(Properties properties) {
        if (properties.containsKey(ASYNC_DISTRIBUTION_OPTION)) {
            try {
                return ConversionHelper.toBoolean((Object)properties.get(ASYNC_DISTRIBUTION_OPTION));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't parse DaemonDistribution option.", (Throwable)exc);
            }
        }
        return false;
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.distributionModule == null) {
            this.distributionModule = new DistributionModule(this.distributionClassName, this.properties, firstTime);
        }
        if (this.properties != null) {
            this.isAsyncDistribution = this.isAsyncDistribution(this.properties);
        }
        if (this.distributionDaemon == null && this.isAsyncDistribution) {
            this.distributionDaemon = new DistributionDaemon(this.distributionModule.getDistributionHandler(), this.getName(), this);
            this.distributionDaemon.start();
        }
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        if (this.distributionModule != null) {
            this.distributionModule.close();
        }
        if (this.distributionDaemon != null) {
            this.distributionDaemon.close();
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        if (!this.batchDistribution && this.messages.size() > 0) {
            return cm;
        }
        List msgs = cm.getMessages();
        Iterator ite = msgs.iterator();
        while (ite.hasNext()) {
            Message msg = (Message)ite.next();
            try {
                this.distributionModule.processMessage(msg);
                ++this.nbMsgsDeliverSinceCreation;
                ite.remove();
            }
            catch (Exception exc) {
                if (!this.isAsyncDistribution) {
                    if (logger.isLoggable(BasicLevel.WARN)) {
                        logger.log(BasicLevel.WARN, (Object)"DistributionQueue.preProcess: distribution error.", (Throwable)exc);
                    }
                } else if (this.distributionDaemon != null) {
                    this.distributionDaemon.push(msg);
                } else if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"DistributionQueue.preProcess: distribution distributionDaemon = null but we are in async distribution mode.", (Throwable)exc);
                }
                if (this.batchDistribution) continue;
                break;
            }
        }
        if (msgs.size() > 0) {
            return cm;
        }
        return null;
    }

    protected void postProcess(ClientMessages msgs) {
        super.postProcess(msgs);
        if (this.distributionDaemon != null) {
            List ackList;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"DistributionQueue.postProcess(...)");
            }
            if ((ackList = this.distributionDaemon.getAckList()) != null) {
                String id2 = null;
                block0: for (String id2 : ackList) {
                    int i = 0;
                    org.objectweb.joram.mom.messages.Message message = null;
                    while (i < this.messages.size()) {
                        message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
                        if (!id2.equals(message.getId())) continue;
                        this.messages.remove(i);
                        message.delete();
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue block0;
                        logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.postProcess removes " + id2));
                        continue block0;
                    }
                }
            }
        }
    }

    public String toString() {
        return "DistributionQueue:" + this.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpNot(WakeUpNot not) {
        List ackList;
        if (logger.isLoggable(BasicLevel.DEBUG) && !this.isAsyncDistribution) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.wakeUpNot(" + (Object)((Object)not) + ')'));
        }
        super.wakeUpNot(not);
        if (this.distributionDaemon != null && (ackList = this.distributionDaemon.getAckList()) != null) {
            String id2 = null;
            block5: for (String id2 : ackList) {
                int i = 0;
                org.objectweb.joram.mom.messages.Message message = null;
                while (i < this.messages.size()) {
                    message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
                    if (!id2.equals(message.getId())) continue;
                    this.messages.remove(i);
                    message.delete();
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue block5;
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.wakeUpNot removes " + id2));
                    continue block5;
                }
            }
        }
        Iterator ite = this.messages.iterator();
        while (ite.hasNext()) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)ite.next();
            try {
                this.distributionModule.processMessage(msg.getFullMessage());
                ++this.nbMsgsDeliverSinceCreation;
                ite.remove();
                msg.delete();
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG) && !this.isAsyncDistribution) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.wakeUpNot redelivery number " + msg.getDeliveryCount() + " failed."), (Throwable)exc);
                } else if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.wakeUpNot redelivery " + msg.getId() + " number " + msg.getDeliveryCount()));
                }
                if (this.distributionDaemon == null) {
                    msg.incDeliveryCount();
                }
                if (this.isUndeliverable(msg)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Message can't be delivered, send to DMQ.");
                    }
                    ite.remove();
                    msg.delete();
                    DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(msg.getFullMessage(), (short)2);
                    dmqManager.sendToDMQ();
                    continue;
                }
                if (this.distributionDaemon != null) {
                    DistributionDaemon distributionDaemon = this.distributionDaemon;
                    synchronized (distributionDaemon) {
                        ((Object)((Object)this.distributionDaemon)).notify();
                    }
                }
                if (logger.isLoggable(BasicLevel.DEBUG) && this.distributionDaemon != null) {
                    logger.log(BasicLevel.DEBUG, (Object)("DistributionQueue.wakeUpNot distributionDaemon = " + (Object)((Object)this.distributionDaemon) + ", distributionDaemon.isEmpty() = " + this.distributionDaemon.isEmpty()));
                }
                if (this.distributionDaemon != null) {
                    if (!this.distributionDaemon.isEmpty()) break;
                    this.distributionDaemon.push(msg.getFullMessage());
                }
                if (this.batchDistribution) continue;
                break;
            }
        }
    }

    protected void processSetRight(AgentId user, int right) throws RequestException {
        if (right == READ) {
            throw new RequestException("A distribution queue can't be set readable.");
        }
        super.processSetRight(user, right);
    }
}

