/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.objectweb.joram.mom.dest.MonitoringElement;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MonitoringHelper {
    static Logger logger = Debug.getLogger((String)MonitoringHelper.class.getName());

    public static void getJMXValues(Message message, Vector elements) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("MonitoringHelper.getJMXValues() -> " + elements.size()));
        }
        for (int i = 0; i < elements.size(); ++i) {
            MonitoringElement element = (MonitoringElement)elements.elementAt(i);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("MonitoringHelper.getJMXValues() -> " + element.mbean));
            }
            try {
                Set mBeans = MXWrapper.queryNames((String)element.mbean);
                if (mBeans == null) continue;
                for (String mBean : mBeans) {
                    for (int j = 0; j < element.attributes.length; ++j) {
                        try {
                            if (element.attributes[j].equals("*")) {
                                List attributes = MXWrapper.getAttributeNames((String)mBean);
                                if (attributes == null) continue;
                                for (int k = 0; k < attributes.size(); ++k) {
                                    MonitoringHelper.setMessageProperty(message, mBean, (String)attributes.get(k));
                                }
                                continue;
                            }
                            MonitoringHelper.setMessageProperty(message, mBean, element.attributes[j]);
                            continue;
                        }
                        catch (Exception exc) {
                            logger.log(BasicLevel.ERROR, (Object)(" getAttributes  on " + mBean + " error."), (Throwable)exc);
                        }
                    }
                }
                continue;
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid MBean name : " + element.mbean), (Throwable)exc);
            }
        }
    }

    private static void setMessageProperty(Message message, String mbeanName, String attrName) throws Exception {
        Object value = MXWrapper.getAttribute((String)mbeanName, (String)attrName);
        if (value != null) {
            message.setProperty(mbeanName + ":" + attrName, value);
        }
    }

    public static String[] getMonitoredAttributes(Vector elements) {
        String[] ret = new String[elements.size()];
        for (int i = 0; i < ret.length; ++i) {
            StringBuffer strbuf = new StringBuffer();
            MonitoringElement element = (MonitoringElement)elements.elementAt(i);
            strbuf.append(element.mbean).append('=').append(element.attributes[0]);
            for (int j = 1; j < element.attributes.length; ++j) {
                strbuf.append(',').append(element.attributes[j]);
            }
            ret[i] = strbuf.toString();
            strbuf.setLength(0);
        }
        return ret;
    }

    public static void addMonitoredAttributes(Vector elements, String MBeanName, String attributes) {
        elements.add(new MonitoringElement(MBeanName, attributes));
    }

    public static void delMonitoredAttributes(Vector elements, String mbean) {
        int i = 0;
        while (i < elements.size()) {
            MonitoringElement element = (MonitoringElement)elements.elementAt(i);
            if (element.mbean.equals(mbean)) {
                elements.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }
}

