/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MetaInfScannerBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static Log logger = LogFactory.getLog(MetaInfScannerBundleTrackerCustomizer.class);
    private static final String[] DENY_FILTERS = new String[]{"META-INF/maven", "META-INF/MANIFEST.MF", "META-INF/LICENSE"};
    private Map<Bundle, List<URL>> bundleMapEntries = new WeakHashMap<Bundle, List<URL>>();
    private Map<String, List<URL>> urlEntries = new HashMap<String, List<URL>>();

    public MetaInfScannerBundleTrackerCustomizer(BundleContext bundleContext) {
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        logger.debug((Object)"Bundle ''{0}'' with event ''{1}''", new Object[]{bundle, event});
        return this.register(bundle);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        logger.debug((Object)"Bundle ''{0}'' with event ''{1}''", new Object[]{bundle, event});
        if (bundle.getState() == 16 || bundle.getState() == 32) {
            this.unregister(bundle);
        }
        if (bundle.getState() == 32) {
            this.register(bundle);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        logger.debug((Object)"Bundle ''{0}'' with event ''{1}''", new Object[]{bundle, event});
        this.unregister(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> register(Bundle bundle) {
        ArrayList<URL> list = new ArrayList<URL>();
        Enumeration enumeration = bundle.findEntries("META-INF", "*", true);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                String path = url.getPath();
                if (path.length() > 1) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) continue;
                boolean denied = false;
                for (String filter : DENY_FILTERS) {
                    if (!path.startsWith(filter)) continue;
                    denied = true;
                    break;
                }
                if (denied) continue;
                list.add(url);
            }
            Map<Bundle, List<URL>> map = this.bundleMapEntries;
            synchronized (map) {
                this.bundleMapEntries.put(bundle, list);
            }
            this.refresh();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Bundle bundle) {
        Map<Bundle, List<URL>> map = this.bundleMapEntries;
        synchronized (map) {
            this.bundleMapEntries.remove(bundle);
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<Bundle, List<URL>> map = this.bundleMapEntries;
        synchronized (map) {
            Map<String, List<URL>> map2 = this.urlEntries;
            synchronized (map2) {
                this.urlEntries.clear();
                Collection<List<URL>> listUrls = this.bundleMapEntries.values();
                for (List<URL> urls : listUrls) {
                    for (URL url : urls) {
                        List<URL> lstURL;
                        String path = url.getPath();
                        if (path.length() > 1) {
                            path = path.substring(1);
                        }
                        if ((lstURL = this.urlEntries.get(path)) == null) {
                            lstURL = new ArrayList<URL>();
                            this.urlEntries.put(path, lstURL);
                        }
                        lstURL.add(url);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getEntries(String name) {
        ArrayList<URL> newList = null;
        Map<String, List<URL>> map = this.urlEntries;
        synchronized (map) {
            List<URL> foundList = this.urlEntries.get(name);
            if (foundList != null) {
                newList = new ArrayList<URL>();
                newList.addAll(foundList);
            }
        }
        return newList;
    }
}

