/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.callback;

import java.awt.GridLayout;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogCallbackHandler
implements CallbackHandler {
    private JTextField loginField = null;
    private JTextField passwordField = null;
    private boolean cancelled = false;
    private String title = "Login Dialog";
    private String username = "Username  ";
    private String password = "Password  ";
    private String loginButton = "Login !";
    private String cancelButton = "Cancel";
    private static final int MAX_FIELD_LENGTH = 20;
    private int passwordLength = 20;
    private int usernameLength = 20;
    private char echoChar = (char)42;
    private boolean echoCharOn = false;
    private String[] connectOptionNames;

    public DialogCallbackHandler() {
        int i = 0;
        this.connectOptionNames = new String[2];
        this.connectOptionNames[i] = this.loginButton;
        this.connectOptionNames[++i] = this.cancelButton;
    }

    public DialogCallbackHandler(String title) {
        this();
        this.title = title;
    }

    public DialogCallbackHandler(String title, String username, String password) {
        this();
        this.title = title;
        this.username = username;
        this.password = password;
    }

    public DialogCallbackHandler(String title, String username, String password, String loginButton, String cancelButton, int usernameLength, int passwordLength, char echoChar) {
        this(title, username, password);
        this.echoCharOn = true;
        this.echoChar = echoChar;
        this.loginButton = loginButton;
        this.cancelButton = cancelButton;
        this.passwordLength = passwordLength;
        this.usernameLength = usernameLength;
        this.echoChar = echoChar;
    }

    private void dialogInit(boolean isEchoOn) {
        this.echoCharOn = isEchoOn || this.echoCharOn;
        this.dialogInit();
    }

    private void dialogInit() {
        JLabel userNameLabel = new JLabel(this.username, 4);
        this.loginField = new JTextField("");
        JLabel passwordLabel = new JLabel(this.password, 4);
        if (!this.echoCharOn) {
            this.passwordField = new JPasswordField(this.passwordLength);
            ((JPasswordField)this.passwordField).setEchoChar(this.echoChar);
        } else {
            this.passwordField = new JTextField(this.passwordLength);
        }
        JPanel connectionPanel = new JPanel(false);
        connectionPanel.setLayout(new BoxLayout(connectionPanel, 0));
        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new GridLayout(0, 1));
        namePanel.add(userNameLabel);
        namePanel.add(passwordLabel);
        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new GridLayout(0, 1));
        fieldPanel.add(this.loginField);
        fieldPanel.add(this.passwordField);
        connectionPanel.add(namePanel);
        connectionPanel.add(fieldPanel);
        int choice = JOptionPane.showOptionDialog(null, connectionPanel, this.title, 2, 1, null, this.connectOptionNames, this.loginField);
        this.cancelled = choice == 0 ? false : (choice == 2 ? true : (choice == -1 ? true : true));
        if (this.cancelled) {
            this.loginField.setText("Invalid");
            this.passwordField.setText("Invalid");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i;
        if (this.cancelled) {
            return;
        }
        boolean found = false;
        for (i = 0; i < callbacks.length && !found; ++i) {
            if (!(callbacks[i] instanceof PasswordCallback)) continue;
            found = true;
            this.dialogInit(((PasswordCallback)callbacks[i]).isEchoOn());
        }
        if (!found) {
            this.dialogInit();
        }
        for (i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.loginField.getText());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.passwordField.getText().toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

