/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.principal;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.lib.XML;
import org.ow2.jonas.security.internal.realm.principal.UserMBean;
import org.ow2.jonas.security.realm.lib.HashPassword;
import org.ow2.jonas.security.realm.principal.JUser;

public class User
implements Principal,
Serializable,
UserMBean,
JUser {
    protected static final String SEPARATOR = ",";
    private String name = null;
    private String password = null;
    private HashPassword hashPassword = null;
    private Vector groups = new Vector();
    private Vector roles = new Vector();
    private ArrayList combinedRoles = new ArrayList();

    public User() {
    }

    public User(String name, String password) {
        this.setName(name);
        this.setPassword(password);
    }

    public void setName(String name) {
        this.name = name.startsWith("##DN##") ? name.replace('=', '#').replace(',', '%').replace(' ', '$') : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.setHashPassword(HashHelper.getHashPassword(password));
    }

    protected void setHashPassword(HashPassword hashPassword) {
        this.hashPassword = hashPassword;
    }

    public HashPassword getHashPassword() {
        return this.hashPassword;
    }

    public void setGroups(String groups) {
        StringTokenizer st = new StringTokenizer(groups, SEPARATOR);
        String group = null;
        while (st.hasMoreTokens()) {
            group = st.nextToken().trim();
            this.addGroup(group);
        }
    }

    public String getGroups() {
        String groupsList = "";
        Enumeration g = this.groups.elements();
        int nb = 0;
        String group = null;
        while (g.hasMoreElements()) {
            if (nb > 0) {
                groupsList = groupsList + ", ";
            }
            group = (String)g.nextElement();
            groupsList = groupsList + group;
        }
        return groupsList;
    }

    @Override
    public String[] getArrayGroups() {
        return this.groups.toArray(new String[this.groups.size()]);
    }

    public void setRoles(String roles) {
        if (roles != null) {
            StringTokenizer st = new StringTokenizer(roles, SEPARATOR);
            String role = null;
            while (st.hasMoreTokens()) {
                role = st.nextToken().trim();
                this.addRole(role);
            }
        }
    }

    @Override
    public void addGroup(String group) {
        if (!this.groups.contains(group)) {
            this.groups.addElement(group);
        }
    }

    @Override
    public void addRole(String role) {
        if (!this.roles.contains(role)) {
            this.roles.addElement(role);
        }
    }

    @Override
    public void removeGroup(String group) {
        if (this.groups.contains(group)) {
            this.groups.removeElement(group);
        }
    }

    @Override
    public void removeRole(String role) {
        if (this.roles.contains(role)) {
            this.roles.removeElement(role);
        }
    }

    public String getRoles() {
        String rolesList = "";
        Enumeration r = this.roles.elements();
        int nb = 0;
        String role = null;
        while (r.hasMoreElements()) {
            if (nb > 0) {
                rolesList = rolesList + ", ";
            }
            role = (String)r.nextElement();
            rolesList = rolesList + role;
        }
        return rolesList;
    }

    public void setCombinedRoles(ArrayList combinedRoles) {
        this.combinedRoles = combinedRoles;
    }

    public ArrayList getCombinedRoles() {
        return this.combinedRoles;
    }

    @Override
    public String[] getArrayRoles() {
        return this.roles.toArray(new String[this.roles.size()]);
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<user name=\"");
        xml.append(this.name);
        xml.append("\" password=\"");
        if (this.password != null) {
            xml.append(this.password);
        }
        xml.append("\"");
        XML.appendVectorToBuffer("groups=", xml, this.groups);
        XML.appendVectorToBuffer("roles=", xml, this.roles);
        xml.append(" />");
        return xml.toString();
    }

    @Override
    public String toString() {
        return this.toXML();
    }
}

