/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentCreateRequest;
import fr.dyade.aaa.agent.AgentDeleteRequest;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentMBean;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.EngineThread;
import fr.dyade.aaa.agent.ExceptionNotification;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.Role;
import fr.dyade.aaa.agent.RoleMultiple;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownNotification;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Agent
implements AgentMBean,
Serializable {
    static final long serialVersionUID = 1L;
    private transient boolean updated = true;
    transient int reactNb = 0;
    public boolean agentProfiling = false;
    transient long reactTime = 0L;
    transient long commitTime = 0L;
    transient AgentId id;
    transient String name;
    protected transient boolean fixed;
    protected transient Logger logmon = null;
    transient long last;
    public static final String emptyString = "";
    transient boolean deployed = false;

    public int getReactNb() {
        return this.reactNb;
    }

    public boolean isAgentProfiling() {
        return this.agentProfiling;
    }

    public void setAgentProfiling(boolean agentProfiling) {
        this.agentProfiling = agentProfiling;
    }

    public long getReactTime() {
        return this.reactTime;
    }

    public void resetReactTime() {
        this.reactTime = 0L;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public void resetCommitTime() {
        this.commitTime = 0L;
    }

    public void resetTimer() {
        this.resetReactTime();
        this.resetCommitTime();
    }

    protected void setNoSave() {
        this.updated = false;
    }

    protected void setSave() {
        this.updated = true;
    }

    protected final boolean needToBeCommited() {
        try {
            ((EngineThread)Thread.currentThread()).engine.needToBeCommited = true;
            return true;
        }
        catch (ClassCastException exc) {
            return false;
        }
    }

    protected final void save() throws IOException {
        if (this.updated) {
            AgentServer.getTransaction().save(this, this.id.toString());
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + this.id + " [" + this.name + "] saved"));
            }
        } else {
            this.updated = true;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + this.id + " [" + this.name + "] not saved"));
            }
        }
    }

    static final Agent load(AgentId id) throws IOException, ClassNotFoundException {
        Agent ag = (Agent)AgentServer.getTransaction().load(id.toString());
        if (ag != null) {
            ag.id = id;
            ag.deployed = true;
        }
        return ag;
    }

    public String getName() {
        if (this.name == null || this.name.length() == 0) {
            return this.id.toString();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getLogTopic() {
        return "fr.dyade.aaa.agent.Agent";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.name == null) {
            out.writeUTF(emptyString);
        } else {
            out.writeUTF(this.name);
        }
        out.writeBoolean(this.fixed);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        if (this.name.length() == 0) {
            this.name = null;
        }
        this.fixed = in.readBoolean();
        this.updated = true;
    }

    public Agent() {
        this(null, false);
    }

    public Agent(boolean fixed) {
        this(null, fixed);
    }

    public Agent(String name) {
        this(name, false);
    }

    public Agent(String name, boolean fixed) {
        this(AgentServer.getServerId(), name, fixed);
    }

    public Agent(short to) {
        this(to, null, false);
    }

    public Agent(short to, String name) {
        this(to, name, false);
    }

    public Agent(short to, boolean fixed) {
        this(to, null, fixed);
    }

    public Agent(short to, String name, boolean fixed) {
        AgentId id = null;
        try {
            id = new AgentId(to);
        }
        catch (IOException exc) {
            this.logmon = Debug.getLogger((String)("fr.dyade.aaa.agent.Agent.#" + AgentServer.getServerId()));
            this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", can't allocate new AgentId"), (Throwable)exc);
        }
        this.initState(name, fixed, id);
    }

    Agent(String name, boolean fixed, AgentId id) {
        this.initState(name, fixed, id);
    }

    private void initState(String name, boolean fixed, AgentId id) {
        this.name = name;
        this.fixed = fixed;
        this.id = id;
        this.logmon = Debug.getLogger((String)this.getLogTopic());
    }

    public Agent(String name, boolean fixed, int stamp) {
        if (stamp < AgentId.MinWKSIdStamp || stamp > AgentId.MaxWKSIdStamp) {
            this.logmon = Debug.getLogger((String)("fr.dyade.aaa.agent.Agent.#" + AgentServer.getServerId()));
            this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", well known service stamp out of range: " + stamp));
            throw new IllegalArgumentException("Well known service stamp out of range: " + stamp);
        }
        AgentId id = new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), stamp);
        this.initState(name, fixed, id);
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public final void deploy() throws IOException {
        this.deploy(null);
    }

    public final void deploy(AgentId reply) throws IOException {
        if (this.id == null || this.id.isNullId()) {
            this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", can't deploy " + this.toString() + ", id is null"));
            throw new IOException("Can't deploy agent, id is null");
        }
        if (this.deployed) {
            this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", can't deploy " + this.toString() + ", already deployed"));
            throw new IOException("Can't deploy agent, already deployed");
        }
        Channel.sendTo(AgentId.factoryId(this.id.getTo()), new AgentCreateRequest(this, reply));
        this.deployed = true;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.toString() + " deployed"));
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",name=").append(this.name);
        strbuf.append(",id=").append(this.id.toString());
        strbuf.append(",fixed=").append(this.fixed);
        strbuf.append(')');
        return strbuf.toString();
    }

    public final String getAgentId() {
        return this.id.toString();
    }

    public final AgentId getId() {
        return this.id;
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        this.logmon = Debug.getLogger((String)this.getLogTopic());
        this.updated = true;
        try {
            MXWrapper.registerMBean((Object)this, (String)"AgentServer", (String)this.getMBeanName());
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.WARN, (Object)("Agent" + this.id + " [" + this.name + "] jmx failed"), (Throwable)exc);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + this.id + " [" + this.name + "], initialized: " + firstTime));
        }
    }

    private String getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("server=").append(AgentServer.getName());
        strbuf.append(",cons=Engine#").append(this.getId().getTo());
        if (this.name == null || this.name.length() == 0) {
            strbuf.append(",agent=").append(this.getAgentId());
        } else {
            strbuf.append(",agent=").append(this.name).append('[').append(this.getAgentId()).append(']');
        }
        return strbuf.toString();
    }

    protected final void sendTo(AgentId to, Notification not) {
        if (Thread.currentThread() == AgentServer.engine.thread) {
            AgentServer.engine.push(this.getId(), to, not);
        } else {
            Channel.channel.directSendTo(this.getId(), to, not);
        }
    }

    protected final void sendTo(Role role, Notification not) {
        if (role == null) {
            return;
        }
        this.sendTo(role.getListener(), not);
    }

    protected final void sendTo(RoleMultiple role, Notification not) {
        if (role == null) {
            return;
        }
        Enumeration<AgentId> to = role.getListeners();
        if (to == null) {
            return;
        }
        while (to.hasMoreElements()) {
            this.sendTo(to.nextElement(), not);
        }
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(AgentId agent) {
        if (this.deployed) {
            this.sendTo(AgentId.factoryId(this.id.getTo()), (Notification)new AgentDeleteRequest(agent));
        }
    }

    public void delete(AgentId agent, Object extraInformation) {
        if (this.deployed) {
            this.sendTo(AgentId.factoryId(this.id.getTo()), (Notification)new AgentDeleteRequest(agent, extraInformation));
        }
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (not instanceof DeleteNot) {
            this.delete(((DeleteNot)not).reply);
        } else if (not instanceof UnknownAgent || not instanceof UnknownNotification || not instanceof ExceptionNotification) {
            this.logmon.log(BasicLevel.WARN, (Object)(this.toString() + ".react(" + from + ", " + not + ")"));
        } else {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.toString() + ".react(" + from + ", " + not + ")"));
            this.sendTo(from, (Notification)new UnknownNotification(this.id, not));
        }
    }

    public void agentFinalize(boolean lastTime) {
        try {
            MXWrapper.unregisterMBean((String)"AgentServer", (String)this.getMBeanName());
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.WARN, (Object)("Agent" + this.id + " [" + this.name + "] jmx failed"), (Throwable)exc);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)("Agent" + this.id + " [" + this.name + "],  finalize: " + lastTime));
        }
    }
}

