/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.common.Daemon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class NGNetwork
extends StreamNetwork {
    static final int Kb = 1024;
    static final int Mb = 0x100000;
    static final int SO_BUFSIZE = 65536;
    Selector selector = null;
    Dispatcher dispatcher = null;
    NetServer[] dmon = null;
    static final int NbNetServer = 1;
    CnxHandler[] handlers = null;
    ServerSocketChannel listen = null;

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.handlers = new CnxHandler[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            if (servers[i] == AgentServer.getServerId()) continue;
            this.handlers[i] = new CnxHandler(this.getName(), servers[i]);
        }
    }

    void open() throws IOException {
        this.listen = ServerSocketChannel.open();
        this.listen.configureBlocking(false);
        this.listen.socket().bind(new InetSocketAddress(this.port));
        this.listen.register(this.selector, 16);
    }

    void close() {
        try {
            this.listen.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listen = null;
    }

    public void start() throws Exception {
        try {
            int i;
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
            this.selector = Selector.open();
            for (i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].init();
            }
            this.open();
            if (this.dispatcher == null) {
                this.dispatcher = new Dispatcher(this.getName(), this.logmon);
            }
            if (this.dmon == null) {
                this.dmon = new NetServer[1];
                for (i = 0; i < 1; ++i) {
                    this.dmon[i] = new NetServer(this.getName(), this.logmon);
                }
            }
            if (!this.dispatcher.isRunning()) {
                this.dispatcher.start();
            }
            for (i = 0; i < 1; ++i) {
                if (this.dmon[i].isRunning()) continue;
                this.dmon[i].start();
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    final CnxHandler getHandler(short sid) {
        return this.handlers[this.index(sid)];
    }

    public void wakeup() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", wakeup"));
    }

    public void stop() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.dmon != null) {
            for (int i = 0; i < 1; ++i) {
                if (this.dmon[i] == null) continue;
                this.dmon[i].stop();
            }
        }
        this.close();
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        if (this.dispatcher == null || !this.dispatcher.isRunning()) {
            return false;
        }
        if (this.dmon == null) {
            return false;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.dmon[i] != null && this.dmon[i].isRunning()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.dispatcher != null) {
            strbuf.append(this.dispatcher.toString()).append("\n");
        }
        for (int i = 0; i < 1; ++i) {
            if (this.dmon == null || this.dmon[i] == null) continue;
            strbuf.append(this.dmon[i].toString()).append("\n");
        }
        return strbuf.toString();
    }

    void cnxStart(SocketChannel channel) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remotely started"));
        }
        channel.socket().setSendBufferSize(65536);
        channel.socket().setReceiveBufferSize(65536);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " bufsize: " + channel.socket().getReceiveBufferSize() + ", " + channel.socket().getSendBufferSize()));
        }
        ByteBuffer buf = ByteBuffer.allocate(6);
        channel.read(buf);
        buf.flip();
        short sid = buf.getShort();
        int boot = buf.getInt();
        CnxHandler cnx = this.getHandler(sid);
        if (cnx.remoteStart(channel, boot)) {
            cnx.startEnd();
        }
    }

    final class MessageVector {
        private Message[] elementData = new Message[20];
        private int elementCount = 0;
        private int current = -1;

        public synchronized Message nextMessage() {
            if (this.current + 1 < this.elementCount) {
                return this.elementData[++this.current];
            }
            return null;
        }

        public synchronized int size() {
            return this.elementCount;
        }

        public synchronized void reset() {
            this.current = -1;
        }

        public synchronized void addMessage(Message msg) {
            if (this.elementCount + 1 > this.elementData.length) {
                Message[] oldData = this.elementData;
                this.elementData = new Message[this.elementData.length * 2];
                System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
            }
            this.elementData[this.elementCount++] = msg;
        }

        public synchronized void removeCurrent() {
            if (this.elementCount > this.current + 1) {
                System.arraycopy(this.elementData, this.current + 1, this.elementData, this.current, this.elementCount - this.current - 1);
            }
            this.elementData[this.elementCount - 1] = null;
            --this.elementCount;
            --this.current;
        }

        public synchronized Message removeMessage(int stamp) {
            Message msg = null;
            for (int index = 0; index < this.elementCount; ++index) {
                msg = this.elementData[index];
                if (msg.not == null || msg.getStamp() != stamp) continue;
                if (this.elementCount > index + 1) {
                    System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - index - 1);
                }
                this.elementData[this.elementCount - 1] = null;
                --this.elementCount;
                if (index <= this.current) {
                    --this.current;
                }
                return msg;
            }
            throw new NoSuchElementException();
        }

        public String toString() {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append(super.toString());
            strbuf.append(',').append(this.current);
            strbuf.append(',').append(this.elementCount);
            for (int i = 0; i < this.elementCount; ++i) {
                strbuf.append(",(").append(this.elementData[i]).append(')');
            }
            return strbuf.toString();
        }
    }

    class CnxHandler {
        private short sid;
        private String name = null;
        private boolean local = false;
        private ServerDesc server;
        SocketChannel channel = null;
        long lasttry = 0L;
        int nbwrite = 0;
        MessageOutputStream mos = null;
        ByteBuffer bufout = null;
        MessageVector sendlist = null;
        ByteBuffer bufin = null;
        MessageInputStream mis = null;

        CnxHandler(String name, short sid) throws IOException {
            this.sid = sid;
            this.name = name + ".cnxHandler#" + sid;
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", created"));
            }
            this.mos = new MessageOutputStream();
            this.bufin = ByteBuffer.allocateDirect(65536);
            this.mis = new MessageInputStream();
            this.sendlist = new MessageVector();
        }

        void init() throws IOException, UnknownServerException {
            this.server = AgentServer.getServerDesc(this.sid);
            if (this.sendlist.size() > 0) {
                this.start();
            }
        }

        public final String getName() {
            return this.name;
        }

        void start() throws IOException {
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", try to start"));
            }
            long currentTimeMillis = System.currentTimeMillis();
            if (this.server == null) {
                return;
            }
            if (this.server.retry < NGNetwork.this.WDNbRetryLevel1 && this.server.last + NGNetwork.this.WDRetryPeriod1 < currentTimeMillis || this.server.retry < NGNetwork.this.WDNbRetryLevel2 && this.server.last + NGNetwork.this.WDRetryPeriod2 < currentTimeMillis || this.server.last + NGNetwork.this.WDRetryPeriod3 < currentTimeMillis) {
                if (this.localStart()) {
                    this.startEnd();
                } else {
                    this.server.last = currentTimeMillis;
                    ++this.server.retry;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean localStart() {
            CnxHandler cnxHandler = this;
            synchronized (cnxHandler) {
                if (this.channel != null || this.local) {
                    if (NGNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                        NGNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"));
                    }
                    return false;
                }
                this.local = true;
            }
            AbstractInterruptibleChannel channel = null;
            try {
                InetSocketAddress addr = new InetSocketAddress(this.server.getAddr(), this.server.getPort());
                channel = SocketChannel.open(addr);
                ((SocketChannel)channel).socket().setSendBufferSize(65536);
                ((SocketChannel)channel).socket().setReceiveBufferSize(65536);
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " bufsize: " + ((SocketChannel)channel).socket().getReceiveBufferSize() + ", " + ((SocketChannel)channel).socket().getSendBufferSize()));
                }
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeBoot: " + NGNetwork.this.getBootTS()));
                }
                ByteBuffer buf = ByteBuffer.allocate(6);
                buf.putShort(AgentServer.getServerId());
                buf.putInt(NGNetwork.this.getBootTS());
                buf.flip();
                ((SocketChannel)channel).write(buf);
                buf.flip();
                if (((SocketChannel)channel).read(buf) <= 0) {
                    throw new ConnectException("Can't get status");
                }
                buf.flip();
                int boot = buf.getInt();
                AgentServer.getTransaction().begin();
                NGNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
            }
            catch (Exception exc) {
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    NGNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused."), (Throwable)exc);
                }
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.local = false;
                return false;
            }
            this.channel = channel;
            this.local = false;
            return true;
        }

        synchronized boolean remoteStart(SocketChannel channel, int boot) {
            try {
                if (this.channel != null || this.local && this.server.sid > AgentServer.getServerId()) {
                    throw new ConnectException("Already connected");
                }
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeBoot: " + NGNetwork.this.getBootTS()));
                }
                ByteBuffer buf = ByteBuffer.allocate(4);
                buf.putInt(NGNetwork.this.getBootTS());
                buf.flip();
                channel.write(buf);
                AgentServer.getTransaction().begin();
                NGNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                this.channel = channel;
                return true;
            }
            catch (Exception exc) {
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    NGNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"), (Throwable)exc);
                }
                try {
                    channel.close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                return false;
            }
        }

        private void startEnd() throws IOException {
            this.server.active = true;
            this.server.retry = 0;
            this.nbwrite = 0;
            this.bufin.clear();
            this.channel.configureBlocking(false);
            this.channel.register(NGNetwork.this.selector, this.channel.validOps(), this);
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection started"));
            }
            this.sendlist.reset();
        }

        synchronized void send(Message msg) throws IOException {
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send message: " + msg));
            }
            this.sendlist.addMessage(msg);
            if (this.channel != null && this.bufout == null) {
                SelectionKey key = this.channel.keyFor(NGNetwork.this.selector);
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send message, key=" + key));
                }
                if (key != null) {
                    key.interestOps(this.channel.validOps());
                }
            }
            if (NGNetwork.this.selector == null) {
                NGNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", network not started."));
            } else {
                NGNetwork.this.selector.wakeup();
            }
        }

        private synchronized void write() throws IOException {
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " write-1"));
            }
            if (this.bufout != null && this.nbwrite > 0) {
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " write-2"));
                }
                this.nbwrite -= this.channel.write(this.bufout);
            } else if (this.nbwrite == 0) {
                Message msg;
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " write-3"));
                }
                if ((msg = this.sendlist.nextMessage()) == null) {
                    this.bufout = null;
                    if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " write-4x:" + msg));
                    }
                    this.channel.register(NGNetwork.this.selector, 1, this);
                } else {
                    if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " write-4:" + msg));
                    }
                    this.mos.writeMessage(msg);
                    if (msg.not == null) {
                        NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " remove ack sent"));
                        this.sendlist.removeCurrent();
                    }
                }
            }
        }

        private synchronized void read() throws Exception {
            int bytes = this.channel.read(this.bufin);
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " reads: " + bytes));
            }
            if (bytes == 0) {
                return;
            }
            if (bytes < 0) {
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " cnx remotely closed"));
                }
                this.close();
                return;
            }
            this.bufin.flip();
            while (bytes > 0) {
                Message msg;
                if (this.mis.length == -1) {
                    if (this.mis.getCount() + bytes < 28) {
                        this.bufin.get(this.mis.getBuffer(), this.mis.getCount(), bytes);
                        this.mis.setCount(this.mis.getCount() + bytes);
                        bytes = 0;
                        continue;
                    }
                    this.bufin.get(this.mis.getBuffer(), this.mis.getCount(), 28 - this.mis.getCount());
                    bytes -= 28 - this.mis.getCount();
                    this.mis.setCount(28);
                    msg = this.mis.readHeader();
                    if (this.mis.length != 28) continue;
                    if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ack received #" + msg.stamp));
                    }
                    this.doAck(msg.stamp);
                    msg.free();
                    this.mis.length = -1;
                    this.mis.msg = null;
                    this.mis.setCount(0);
                    continue;
                }
                if (this.mis.getCount() + bytes < this.mis.length - 28) {
                    this.bufin.get(this.mis.getBuffer(), this.mis.getCount(), bytes);
                    this.mis.setCount(this.mis.getCount() + bytes);
                    bytes = 0;
                    continue;
                }
                this.bufin.get(this.mis.getBuffer(), this.mis.getCount(), this.mis.length - 28 - this.mis.getCount());
                bytes -= this.mis.length - 28 - this.mis.getCount();
                this.mis.setCount(this.mis.length - 28);
                msg = this.mis.readMessage();
                int stamp = msg.getStamp();
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", message received #" + stamp));
                }
                NGNetwork.this.deliver(msg);
                this.ack(stamp);
                this.mis.length = -1;
                this.mis.msg = null;
                this.mis.setCount(0);
            }
            this.bufin.clear();
        }

        private final void doAck(int ack) throws IOException {
            Message msg = null;
            try {
                msg = this.sendlist.removeMessage(ack);
                AgentServer.getTransaction().begin();
                msg.delete();
                msg.free();
                AgentServer.getTransaction().commit(true);
                if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remove msg#" + msg.getStamp()));
                }
            }
            catch (NoSuchElementException exc) {
                NGNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't ack, unknown msg#" + ack));
            }
        }

        private final void ack(int stamp) throws Exception {
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", set ack msg#" + stamp));
            }
            Message ack = Message.alloc(AgentId.localId, AgentId.localId(this.server.sid), null);
            ack.source = AgentServer.getServerId();
            ack.dest = AgentServer.getServerDesc((short)this.server.sid).gateway;
            ack.stamp = stamp;
            this.send(ack);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            if (NGNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", close"));
            }
            try {
                this.channel.keyFor(NGNetwork.this.selector).cancel();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    Object var3_4 = null;
                    this.channel = null;
                }
                Object var3_3 = null;
                this.channel = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.channel = null;
                throw throwable;
            }
            this.nbwrite = 0;
            this.bufout = null;
        }

        public String toString() {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append('(').append(super.toString());
            strbuf.append(',').append(this.name);
            strbuf.append(',').append(this.channel);
            strbuf.append(',').append(this.nbwrite);
            strbuf.append(',').append(this.sendlist).append(')');
            return strbuf.toString();
        }

        final class MessageInputStream
        extends ByteArrayInputStream {
            int length;
            Message msg;

            MessageInputStream() {
                super(new byte[512]);
                this.length = -1;
                this.msg = null;
                this.count = 0;
            }

            public void reset() {
                super.reset();
                this.length = -1;
                this.msg = null;
            }

            byte[] getBuffer() {
                return this.buf;
            }

            int getCount() {
                return this.count;
            }

            void setCount(int count) {
                this.count = count;
            }

            Message readHeader() throws Exception {
                this.length = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0);
                this.msg = Message.alloc();
                this.msg.from = new AgentId((short)(((this.buf[4] & 0xFF) << 8) + (this.buf[5] & 0xFF)), (short)(((this.buf[6] & 0xFF) << 8) + (this.buf[7] & 0xFF)), ((this.buf[8] & 0xFF) << 24) + ((this.buf[9] & 0xFF) << 16) + ((this.buf[10] & 0xFF) << 8) + ((this.buf[11] & 0xFF) << 0));
                this.msg.to = new AgentId((short)(((this.buf[12] & 0xFF) << 8) + (this.buf[13] & 0xFF)), (short)(((this.buf[14] & 0xFF) << 8) + (this.buf[15] & 0xFF)), ((this.buf[16] & 0xFF) << 24) + ((this.buf[17] & 0xFF) << 16) + ((this.buf[18] & 0xFF) << 8) + ((this.buf[19] & 0xFF) << 0));
                this.msg.source = (short)(((this.buf[20] & 0xFF) << 8) + ((this.buf[21] & 0xFF) << 0));
                this.msg.dest = (short)(((this.buf[22] & 0xFF) << 8) + ((this.buf[23] & 0xFF) << 0));
                this.msg.stamp = ((this.buf[24] & 0xFF) << 24) + ((this.buf[25] & 0xFF) << 16) + ((this.buf[26] & 0xFF) << 8) + ((this.buf[27] & 0xFF) << 0);
                if (this.length - 28 > this.buf.length) {
                    this.buf = new byte[this.length - 28];
                }
                this.count = 0;
                return this.msg;
            }

            Message readMessage() throws Exception {
                if (this.length > 28) {
                    boolean persistent = (this.buf[28] & 1) == 1;
                    boolean detachable = (this.buf[28] & 0x10) == 16;
                    this.pos = 1;
                    ObjectInputStream ois = new ObjectInputStream(this);
                    this.msg.not = (Notification)ois.readObject();
                    this.msg.not.persistent = persistent;
                    this.msg.not.detachable = detachable;
                    this.msg.not.detached = false;
                } else {
                    this.msg.not = null;
                }
                return this.msg;
            }
        }

        final class MessageOutputStream
        extends ByteArrayOutputStream {
            private ObjectOutputStream oos;

            MessageOutputStream() throws IOException {
                super(256);
                this.oos = null;
                this.oos = new ObjectOutputStream(this);
                this.count = 0;
                this.buf[29] = -84;
                this.buf[30] = -19;
                this.buf[31] = 0;
                this.buf[32] = 5;
            }

            void writeMessage(Message msg) throws IOException {
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(CnxHandler.this.getName() + ", writes " + msg));
                this.buf[4] = (byte)(msg.from.from >>> 8);
                this.buf[5] = (byte)(msg.from.from >>> 0);
                this.buf[6] = (byte)(msg.from.to >>> 8);
                this.buf[7] = (byte)(msg.from.to >>> 0);
                this.buf[8] = (byte)(msg.from.stamp >>> 24);
                this.buf[9] = (byte)(msg.from.stamp >>> 16);
                this.buf[10] = (byte)(msg.from.stamp >>> 8);
                this.buf[11] = (byte)(msg.from.stamp >>> 0);
                this.buf[12] = (byte)(msg.to.from >>> 8);
                this.buf[13] = (byte)(msg.to.from >>> 0);
                this.buf[14] = (byte)(msg.to.to >>> 8);
                this.buf[15] = (byte)(msg.to.to >>> 0);
                this.buf[16] = (byte)(msg.to.stamp >>> 24);
                this.buf[17] = (byte)(msg.to.stamp >>> 16);
                this.buf[18] = (byte)(msg.to.stamp >>> 8);
                this.buf[19] = (byte)(msg.to.stamp >>> 0);
                this.buf[20] = (byte)(msg.source >>> 8);
                this.buf[21] = (byte)(msg.source >>> 0);
                this.buf[22] = (byte)(msg.dest >>> 8);
                this.buf[23] = (byte)(msg.dest >>> 0);
                this.buf[24] = (byte)(msg.stamp >>> 24);
                this.buf[25] = (byte)(msg.stamp >>> 16);
                this.buf[26] = (byte)(msg.stamp >>> 8);
                this.buf[27] = (byte)(msg.stamp >>> 0);
                this.count = 28;
                if (msg.not != null) {
                    this.buf[28] = msg.optToByte();
                    this.count = 33;
                    this.oos.writeObject(msg.not);
                    this.oos.reset();
                    this.oos.flush();
                }
                this.buf[0] = (byte)(this.count >>> 24);
                this.buf[1] = (byte)(this.count >>> 16);
                this.buf[2] = (byte)(this.count >>> 8);
                this.buf[3] = (byte)(this.count >>> 0);
                NGNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(CnxHandler.this.getName() + ", writes " + this.count));
                CnxHandler.this.nbwrite = this.count;
                CnxHandler.this.bufout = ByteBuffer.wrap(this.buf, 0, this.count);
                CnxHandler.this.nbwrite -= CnxHandler.this.channel.write(CnxHandler.this.bufout);
            }
        }
    }

    final class NetServer
    extends Daemon {
        NetServer(String name, Logger logmon) throws IOException {
            super(name + ".NetServer", logmon);
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.close();
        }

        public void run() {
            int nbop = 0;
            CnxHandler cnx = null;
            try {
                while (this.running) {
                    this.canStop = true;
                    try {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", on select"));
                        }
                        nbop = NGNetwork.this.selector.select(NGNetwork.this.WDActivationPeriod);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", on select:" + nbop));
                        }
                    }
                    catch (IOException exc) {
                        // empty catch block
                    }
                    for (int idx = 0; idx < NGNetwork.this.handlers.length; ++idx) {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", " + NGNetwork.this.handlers[idx]));
                        }
                        if (NGNetwork.this.handlers[idx] == null || NGNetwork.this.handlers[idx].sendlist.size() <= 0 || NGNetwork.this.handlers[idx].channel != null) continue;
                        try {
                            NGNetwork.this.handlers[idx].start();
                            continue;
                        }
                        catch (IOException exc) {
                            this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't start cnx#" + idx), (Throwable)exc);
                        }
                    }
                    if (nbop == 0) continue;
                    this.canStop = false;
                    Set<SelectionKey> keys = NGNetwork.this.selector.selectedKeys();
                    Iterator<SelectionKey> it = keys.iterator();
                    while (it.hasNext() && this.running) {
                        SelectionKey key = it.next();
                        it.remove();
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + "(1): " + key + " -> " + key.interestOps()));
                        }
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ":" + key.isValid() + key.isAcceptable() + key.isReadable() + key.isWritable()));
                        try {
                            if (key.isAcceptable()) {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " acceptable"));
                                }
                                ServerSocketChannel server = (ServerSocketChannel)key.channel();
                                SocketChannel channel = server.accept();
                                NGNetwork.this.cnxStart(channel);
                            } else {
                                cnx = (CnxHandler)key.attachment();
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": " + key + " -> " + cnx));
                                }
                                if (key.isValid() && key.isReadable()) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " readable"));
                                    }
                                    cnx.read();
                                }
                                if (key.isValid() && key.isWritable()) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " writable"));
                                    }
                                    cnx.write();
                                } else if (cnx.sendlist.size() > 0) {
                                    key.interestOps(key.channel().validOps());
                                }
                            }
                            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + "(2): " + key + " -> " + key.interestOps()));
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
                            try {
                                cnx.close();
                            }
                            catch (IOException exc2) {
                                this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc2);
                            }
                        }
                    }
                }
            }
            catch (Throwable exc) {
                this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + "Unrecoverable error"), exc);
            }
        }
    }

    final class Dispatcher
    extends Daemon {
        Dispatcher(String name, Logger logmon) {
            super(name + ".dispatcher", logmon);
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            try {
                while (this.running) {
                    block8: {
                        this.canStop = true;
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                        }
                        try {
                            msg = NGNetwork.this.qout.get();
                        }
                        catch (InterruptedException exc) {
                            continue;
                        }
                        this.canStop = false;
                        if (!this.running) break;
                        try {
                            NGNetwork.this.getHandler(msg.getDest()).send(msg);
                        }
                        catch (IOException exc) {
                            if (!this.logmon.isLoggable(BasicLevel.ERROR)) break block8;
                            this.logmon.log(BasicLevel.ERROR, (Object)this.getName(), (Throwable)exc);
                        }
                    }
                    NGNetwork.this.qout.pop();
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.finish();
                throw throwable;
            }
            this.finish();
        }
    }
}

