/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.ext;

import fr.dyade.aaa.ext.NGTransactionMBean;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.StartWithFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;

public final class NGTransaction
extends AbstractTransaction
implements NGTransactionMBean {
    static int LogMemoryCapacity = 4096;
    static int MaxLogFileSize = 0x1000000;
    static int nbLogFile = 4;
    static int minObjInLog = 64;
    boolean syncOnWrite = false;
    boolean useLockFile = true;
    int LogThresholdOperation = 1000;
    String repositoryImpl = "fr.dyade.aaa.util.FileRepository";
    LogManager logManager = null;
    Repository repository = null;

    public final int getLogMemoryCapacity() {
        return LogMemoryCapacity;
    }

    public int getLogMemorySize() {
        return this.logManager.log.size();
    }

    public final int getMaxLogFileSize() {
        return MaxLogFileSize / 0x100000;
    }

    public final void setMaxLogFileSize(int size) {
        if (size > 0) {
            MaxLogFileSize = size * 0x100000;
        }
    }

    public final int getLogFileSize() {
        return this.logManager.getLogFileSize() / 1024;
    }

    public final int getNbLogFiles() {
        return nbLogFile;
    }

    public boolean isSyncOnWrite() {
        return this.syncOnWrite;
    }

    public final int getLogThresholdOperation() {
        return this.LogThresholdOperation;
    }

    public final int getCommitCount() {
        return this.logManager.commitCount;
    }

    public final int getGarbageCount() {
        return this.logManager.garbageCount;
    }

    public long getGarbageTime() {
        return this.logManager.garbageTime;
    }

    public int getNbLoadedFromLog() {
        return this.logManager.loadFromLog;
    }

    public int getGarbageRatio() {
        return (int)(this.logManager.garbageTime * 100L / (System.currentTimeMillis() - this.startTime));
    }

    public void resetGarbageRatio() {
        this.logManager.garbageTime = 0L;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryImpl() {
        return this.repositoryImpl;
    }

    public int getNbSavedObjects() {
        return this.repository.getNbSavedObjects();
    }

    public int getNbDeletedObjects() {
        return this.repository.getNbDeletedObjects();
    }

    public int getNbBadDeletedObjects() {
        return this.repository.getNbBadDeletedObjects();
    }

    public int getNbLoadedObjects() {
        return this.repository.getNbLoadedObjects();
    }

    public final void initRepository() throws IOException {
        LogMemoryCapacity = this.getInteger("Transaction.LogMemoryCapacity", LogMemoryCapacity);
        MaxLogFileSize = this.getInteger("Transaction.MaxLogFileSize", MaxLogFileSize / 0x100000) * 0x100000;
        nbLogFile = this.getInteger("Transaction.NbLogFile", nbLogFile);
        minObjInLog = this.getInteger("Transaction.minObjInLog", minObjInLog);
        this.LogThresholdOperation = this.getInteger("Transaction.LogThresholdOperation", this.LogThresholdOperation);
        Operation.initPool(this.LogThresholdOperation);
        try {
            this.repositoryImpl = this.getProperty("Transaction.RepositoryImpl", this.repositoryImpl);
            this.repository = (Repository)Class.forName(this.repositoryImpl).newInstance();
            this.repository.init(this, this.dir);
        }
        catch (ClassNotFoundException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (InstantiationException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        catch (IllegalAccessException exc) {
            logmon.log(BasicLevel.FATAL, (Object)"NTransaction, cannot initializes the repository ", (Throwable)exc);
            throw new IOException(exc.getMessage());
        }
        this.syncOnWrite = this.getBoolean("Transaction.SyncOnWrite");
        this.useLockFile = this.getBoolean("Transaction.UseLockFile");
        this.logManager = new LogManager(this.dir, this.repository, this.useLockFile, this.syncOnWrite);
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    public synchronized String[] getList(String prefix) {
        return this.logManager.getList(prefix);
    }

    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction, saveInLog(" + dirName + '/' + name + ", " + copy + ", " + first + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Operation op = null;
        op = first ? Operation.alloc(4, dirName, name, buf) : Operation.alloc(1, dirName, name, buf);
        Operation old = log.put(key, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    private final byte[] getFromLog(Hashtable log, Object key) throws IOException {
        Operation op = (Operation)log.get(key);
        if (op != null) {
            if (op.type == 1 || op.type == 4) {
                return op.value;
            }
            if (op.type == 2) {
                throw new FileNotFoundException();
            }
        }
        return null;
    }

    private final synchronized byte[] getFromLog(String dirName, String name) throws IOException {
        Object key = OperationKey.newKey(dirName, name);
        byte[] buf = this.getFromLog(((AbstractTransaction.Context)this.perThreadContext.get()).getLog(), key);
        if (buf != null) {
            return buf;
        }
        return this.logManager.load(dirName, name);
    }

    public byte[] loadByteArray(String dirName, String name) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ")"));
        }
        try {
            return this.getFromLog(dirName, name);
        }
        catch (FileNotFoundException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, loadByteArray(" + dirName + '/' + name + ") not found"));
            }
            return null;
        }
    }

    public final void delete(String dirName, String name) {
        Operation op;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, delete(" + dirName + ", " + name + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Hashtable log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog();
        Operation old = log.put(key, op = Operation.alloc(2, dirName, name));
        if (old != null) {
            if (old.type == 4) {
                op.type = 5;
            }
            old.free();
        }
    }

    public final synchronized void commit(boolean release) throws IOException {
        Hashtable log;
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, commit");
        }
        if (!(log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog()).isEmpty()) {
            this.logManager.commit(log);
            log.clear();
        }
        if (release) {
            this.setPhase(1);
            this.notify();
        } else {
            this.setPhase(3);
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"NTransaction, committed");
        }
    }

    public synchronized void stop() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, stops");
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        this.setPhase(1);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, stopped: " + this.toString()));
        }
    }

    public synchronized void close() {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"NTransaction, closes");
        }
        if (this.phase == 0) {
            return;
        }
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(6);
        this.logManager.stop();
        this.setPhase(0);
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("NTransaction, closed: " + this.toString()));
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",LogMemorySize=").append(this.getLogMemorySize());
        strbuf.append(",LogFileSize=").append(this.getLogFileSize());
        strbuf.append(",CommitCount=").append(this.getCommitCount());
        strbuf.append(",GarbageCount=").append(this.getGarbageCount());
        strbuf.append(",GarbageRatio=").append(this.getGarbageRatio());
        strbuf.append(",NbLoadedFromLog=").append(this.getNbLoadedFromLog());
        strbuf.append(",NbSavedObjects=").append(this.getNbSavedObjects());
        strbuf.append(",NbDeletedObjects=").append(this.getNbDeletedObjects());
        strbuf.append(",NbBadDeletedObjects=").append(this.getNbBadDeletedObjects());
        strbuf.append(",NbLoadedObjects=").append(this.getNbLoadedObjects());
        strbuf.append(')');
        return strbuf.toString();
    }

    public String logCounters() {
        return this.logManager.logCounters();
    }

    public String logContent(int idx) throws IOException {
        this.begin();
        String res = this.logManager.logContent(idx);
        this.commit(true);
        return res;
    }

    public void garbage(int idx) throws IOException {
        this.begin();
        this.logManager.garbage(idx);
        this.commit(true);
    }

    public static class LogFile
    extends RandomAccessFile {
        int logidx;
        int logCounter = 0;
        File dir;
        static int maxUsedIdx = -1;

        public LogFile(File dir, int logidx, String mode) throws FileNotFoundException {
            super(new File(dir, "log#" + logidx), mode);
            if (logidx > maxUsedIdx) {
                maxUsedIdx = logidx;
            }
            this.logidx = logidx;
            this.dir = dir;
        }

        public void renameTo() {
            new File(this.dir, "log#" + this.logidx).renameTo(new File(this.dir, "log#" + ++maxUsedIdx));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LogManager
    extends ByteArrayOutputStream {
        Hashtable<Object, Operation> log = null;
        int logidx;
        LogFile[] logFile = null;
        int current = -1;
        int commitCount = 0;
        int loadFromLog = 0;
        int garbageCount = 0;
        long garbageTime = 0L;
        long lastGarbageDate = 0L;
        private static final String LockPathname = "lock";
        private File lockFile = null;
        private Repository repository = null;
        File dir;
        private String mode;
        private static final byte[] emptyUTFString = new byte[]{0, 0};

        int getLogFileSize() {
            return this.current;
        }

        LogManager(File dir, Repository repository, boolean useLockFile, boolean syncOnWrite) throws IOException {
            super(4096);
            this.repository = repository;
            if (useLockFile) {
                this.lockFile = new File(dir, LockPathname);
                if (!this.lockFile.createNewFile()) {
                    logmon.log(BasicLevel.FATAL, (Object)("NTransaction.init(): Either the server is already running, either you have to remove lock file " + this.lockFile.getAbsolutePath()));
                    throw new IOException("Transaction already running.");
                }
                this.lockFile.deleteOnExit();
            }
            this.mode = syncOnWrite ? "rwd" : "rw";
            this.log = new Hashtable(LogMemoryCapacity);
            long start = System.currentTimeMillis();
            this.logidx = -1;
            this.logFile = new LogFile[nbLogFile];
            this.dir = dir;
            String[] list = dir.list(new StartWithFilter("log#"));
            if (list == null) {
                throw new IOException("NGTransaction error opening " + dir.getAbsolutePath());
            }
            if (list.length == 0) {
                this.logidx = 0;
            } else {
                int i;
                int[] idx = new int[list.length];
                for (i = 0; i < list.length; ++i) {
                    idx[i] = Integer.parseInt(list[i].substring(4));
                }
                Arrays.sort(idx);
                for (i = 0; i < idx.length; ++i) {
                    logmon.log(BasicLevel.WARN, (Object)("NGTransaction.LogManager, rebuilds index: log#" + idx[i]));
                    if (this.logidx == -1) {
                        this.logidx = idx[i];
                    }
                    LogFile logf = new LogFile(dir, idx[i], this.mode);
                    int optype = logf.read();
                    if (optype == 127) {
                        logf.close();
                        continue;
                    }
                    this.logidx = idx[i];
                    this.logFile[this.logidx % NGTransaction.nbLogFile] = logf;
                    while (optype == 3) {
                        optype = this.logFile[this.logidx % nbLogFile].read();
                        while (optype == 4 || optype == 1 || optype == 2) {
                            Operation old;
                            int ptr = (int)this.logFile[this.logidx % nbLogFile].getFilePointer() - 1;
                            ++this.logFile[this.logidx % NGTransaction.nbLogFile].logCounter;
                            String dirName = this.logFile[this.logidx % nbLogFile].readUTF();
                            if (dirName.length() == 0) {
                                dirName = null;
                            }
                            String name = this.logFile[this.logidx % nbLogFile].readUTF();
                            Object key = OperationKey.newKey(dirName, name);
                            if (optype == 1 || optype == 4) {
                                optype = 1;
                                this.logFile[this.logidx % nbLogFile].skipBytes(this.logFile[this.logidx % nbLogFile].readInt());
                            }
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, OPERATION=" + optype + ", " + name));
                            }
                            if ((old = this.log.get(key)) != null) {
                                --this.logFile[old.logidx % NGTransaction.nbLogFile].logCounter;
                                if (old.type == 4 || old.type == 1) {
                                    if (optype == 4 || optype == 1) {
                                        old.logidx = this.logidx;
                                        old.logptr = ptr;
                                    } else if (old.type == 4) {
                                        old.type = 5;
                                        this.log.remove(key);
                                        old.free();
                                        --this.logFile[this.logidx % NGTransaction.nbLogFile].logCounter;
                                    } else {
                                        old.type = 2;
                                        old.logidx = this.logidx;
                                        old.logptr = ptr;
                                    }
                                } else if (old.type == 2) {
                                    if (optype == 4 || optype == 1) {
                                        old.type = 1;
                                    }
                                    old.logidx = this.logidx;
                                    old.logptr = ptr;
                                }
                            } else {
                                Operation op = Operation.alloc(optype, dirName, name);
                                op.logidx = this.logidx;
                                op.logptr = ptr;
                                this.log.put(key, op);
                            }
                            optype = this.logFile[this.logidx % nbLogFile].read();
                        }
                        if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, COMMIT#" + idx));
                    }
                    this.current = (int)this.logFile[this.logidx % nbLogFile].getFilePointer();
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, END#" + this.logidx));
                    }
                    if (optype == 127) continue;
                    throw new IOException("Corrupted transaction log#" + this.logidx);
                }
                logmon.log(BasicLevel.DEBUG, (Object)("NGTransaction.LogManager, log=" + Arrays.toString(this.log.values().toArray())));
            }
            if (this.logFile[this.logidx % nbLogFile] == null) {
                this.logFile[this.logidx % NGTransaction.nbLogFile] = new LogFile(dir, this.logidx, this.mode);
                this.logFile[this.logidx % nbLogFile].setLength(MaxLogFileSize);
                this.logFile[this.logidx % nbLogFile].seek(0L);
                this.logFile[this.logidx % nbLogFile].write(127);
                this.current = 1;
            }
            logmon.log(BasicLevel.INFO, (Object)("NGTransaction.LogManager, ends: " + (System.currentTimeMillis() - start)));
        }

        void commit(Hashtable<Object, Operation> ctxlog) throws IOException {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"NTransaction.LogFile.commit()");
            }
            ++this.commitCount;
            Set<Map.Entry<Object, Operation>> entries = ctxlog.entrySet();
            Iterator<Map.Entry<Object, Operation>> iterator = entries.iterator();
            try {
                while (true) {
                    Map.Entry<Object, Operation> entry = iterator.next();
                    Object key = entry.getKey();
                    Operation op = entry.getValue();
                    if (op.type == 5) continue;
                    op.logidx = this.logidx;
                    op.logptr = this.current + this.count;
                    this.write(op.type);
                    if (op.dirName != null) {
                        this.writeUTF(op.dirName);
                    } else {
                        this.write(emptyUTFString);
                    }
                    this.writeUTF(op.name);
                    if (op.type == 1 || op.type == 4) {
                        this.writeInt(op.value.length);
                        this.write(op.value);
                    }
                    op.value = null;
                    Operation old = this.log.put(key, op);
                    ++this.logFile[this.logidx % NGTransaction.nbLogFile].logCounter;
                    if (old == null) continue;
                    --this.logFile[old.logidx % NGTransaction.nbLogFile].logCounter;
                    if (old.type == 4) {
                        if (op.type == 1) {
                            op.type = 4;
                        } else if (op.type == 2) {
                            op.type = 5;
                            this.log.remove(key);
                            op.free();
                            --this.logFile[this.logidx % NGTransaction.nbLogFile].logCounter;
                        }
                    }
                    old.free();
                }
            }
            catch (NoSuchElementException exc) {
                int i;
                this.write(127);
                this.logFile[this.logidx % nbLogFile].seek(this.current);
                this.logFile[this.logidx % nbLogFile].write(this.buf, 0, this.count);
                this.logFile[this.logidx % nbLogFile].seek(this.current - 1);
                this.logFile[this.logidx % nbLogFile].write(3);
                this.current += this.count;
                this.reset();
                ctxlog.clear();
                for (i = 0; i < nbLogFile; ++i) {
                    if (this.logFile[i] == null || this.logFile[i].logCounter != 0 && (i == this.logidx % nbLogFile || this.logFile[i].logCounter >= minObjInLog)) continue;
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("NTransaction log#" + this.logFile[i].logidx + " is no longer needed, cleans it."));
                    }
                    this.garbage(this.logFile[i]);
                }
                if (this.current > MaxLogFileSize) {
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        for (i = 0; i < nbLogFile; ++i) {
                            if (this.logFile[i] == null) continue;
                            logmon.log(BasicLevel.DEBUG, (Object)("logCounter[" + this.logFile[i].logidx + "]=" + this.logFile[i].logCounter));
                        }
                        logmon.log(BasicLevel.DEBUG, (Object)("log -> " + this.log.size()));
                    }
                    ++this.logidx;
                    if (this.logFile[this.logidx % nbLogFile] != null) {
                        this.garbage(this.logFile[this.logidx % nbLogFile]);
                    }
                    this.logFile[this.logidx % NGTransaction.nbLogFile] = new LogFile(this.dir, this.logidx, this.mode);
                    this.logFile[this.logidx % nbLogFile].setLength(MaxLogFileSize);
                    this.logFile[this.logidx % nbLogFile].seek(0L);
                    this.logFile[this.logidx % nbLogFile].write(127);
                    this.current = 1;
                }
                return;
            }
        }

        public byte[] getFromLog(String dirName, String name) throws IOException {
            Operation op = this.log.get(OperationKey.newKey(dirName, name));
            if (op != null) {
                if (op.type == 1 || op.type == 4) {
                    return this.getFromLog(op);
                }
                if (op.type == 2) {
                    throw new FileNotFoundException();
                }
            }
            return null;
        }

        public byte[] getFromLog(Operation op) throws IOException {
            ++this.loadFromLog;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getFromLog#" + op.logidx + ' ' + op.dirName + '/' + op.name + ": " + op.logptr));
            }
            this.logFile[op.logidx % nbLogFile].seek(op.logptr);
            int optype = this.logFile[op.logidx % nbLogFile].read();
            String dirName = this.logFile[op.logidx % nbLogFile].readUTF();
            if (dirName.length() == 0) {
                dirName = null;
            }
            String name = this.logFile[op.logidx % nbLogFile].readUTF();
            byte[] buf = new byte[this.logFile[op.logidx % nbLogFile].readInt()];
            this.logFile[op.logidx % nbLogFile].readFully(buf);
            return buf;
        }

        public byte[] load(String dirName, String name) throws IOException {
            byte[] buf = this.getFromLog(dirName, name);
            if (buf == null) {
                buf = this.repository.load(dirName, name);
            }
            return buf;
        }

        public String[] getList(String prefix) {
            int i;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getList(" + prefix + ")"));
            }
            String[] list1 = null;
            try {
                list1 = this.repository.list(prefix);
            }
            catch (IOException exc) {
                // empty catch block
            }
            if (list1 == null) {
                list1 = new String[]{};
            }
            Object[] list2 = this.log.keySet().toArray();
            int nb = list1.length;
            for (int i2 = 0; i2 < list2.length; ++i2) {
                if (list2[i2] instanceof String && ((String)list2[i2]).startsWith(prefix)) {
                    int j;
                    for (j = 0; j < list1.length && !list2[i2].equals(list1[j]); ++j) {
                    }
                    if (j < list1.length) {
                        if (this.log.get((Object)list2[i2]).type == 2) {
                            list1[j] = null;
                            --nb;
                        }
                        list2[i2] = null;
                        continue;
                    }
                    if (this.log.get((Object)list2[i2]).type == 1 || this.log.get((Object)list2[i2]).type == 4) {
                        ++nb;
                        continue;
                    }
                    list2[i2] = null;
                    continue;
                }
                list2[i2] = null;
            }
            Object[] list = new String[nb];
            for (i = list1.length - 1; i >= 0; --i) {
                if (list1[i] == null) continue;
                list[--nb] = list1[i];
            }
            for (i = list2.length - 1; i >= 0; --i) {
                if (list2[i] == null) continue;
                list[--nb] = (String)list2[i];
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getList() -> " + Arrays.toString(list)));
            }
            return list;
        }

        public String logCounters() {
            StringBuffer strbuf = new StringBuffer();
            for (int i = 0; i < this.logFile.length; ++i) {
                if (this.logFile[i] == null) continue;
                strbuf.append("log#").append(this.logFile[i].logidx).append(" -> ").append(this.logFile[i].logCounter).append('\n');
            }
            return strbuf.toString();
        }

        public String logContent(int idx) {
            LogFile logf = this.logFile[idx % nbLogFile];
            if (logf == null) {
                return null;
            }
            StringBuffer strbuf = new StringBuffer();
            strbuf.append("counter=").append(logf.logCounter).append('\n');
            Iterator<Operation> iterator = this.log.values().iterator();
            try {
                while (true) {
                    Operation op = iterator.next();
                    if (op.logidx != logf.logidx) continue;
                    if (op.type == 1) {
                        strbuf.append("SAVE ");
                    } else if (op.type == 4) {
                        strbuf.append("CREATE ");
                    } else if (op.type == 2) {
                        strbuf.append("DELETE ");
                    } else {
                        strbuf.append("OP(").append(op.type).append(") ");
                    }
                    strbuf.append(op.dirName).append('/').append(op.name).append('\n');
                }
            }
            catch (NoSuchElementException exc) {
                return strbuf.toString();
            }
        }

        private final void garbage(int idx) throws IOException {
            this.garbage(this.logFile[idx % nbLogFile]);
        }

        private final void garbage(LogFile logf) throws IOException {
            if (logf == null) {
                return;
            }
            ++this.garbageCount;
            long start = System.currentTimeMillis();
            if (logf.logCounter > 0) {
                Iterator<Operation> iterator = this.log.values().iterator();
                try {
                    while (true) {
                        Operation op = iterator.next();
                        if (op.logidx != logf.logidx) continue;
                        if (op.type == 1 || op.type == 4) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Save (" + op.dirName + '/' + op.name + ')'));
                            }
                            byte[] buf = this.getFromLog(op);
                            this.repository.save(op.dirName, op.name, buf);
                        } else if (op.type == 2) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction, LogFile.Delete (" + op.dirName + '/' + op.name + ')'));
                            }
                            this.repository.delete(op.dirName, op.name);
                        }
                        iterator.remove();
                        op.free();
                    }
                }
                catch (NoSuchElementException exc) {
                    this.repository.commit();
                }
            }
            logf.seek(0L);
            logf.write(127);
            if (logf.logidx == this.logidx) {
                this.current = 1;
            } else {
                logf.close();
                logf.renameTo();
                this.logFile[logf.logidx % NGTransaction.nbLogFile] = null;
            }
            this.lastGarbageDate = System.currentTimeMillis();
            this.garbageTime += this.lastGarbageDate - start;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("NTransaction.LogFile.garbage() - end: " + (this.lastGarbageDate - start)));
            }
        }

        void stop() {
            if (this.lockFile != null && !this.lockFile.delete()) {
                logmon.log(BasicLevel.FATAL, (Object)("NTransaction.LogFile, can't delete lockfile: " + this.lockFile.getAbsolutePath()));
            }
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                for (int i = 0; i < this.logFile.length; ++i) {
                    if (this.logFile[i] == null) continue;
                    logmon.log(BasicLevel.DEBUG, (Object)("logCounter[" + i + "]=" + this.logFile[i].logCounter));
                }
                logmon.log(BasicLevel.DEBUG, (Object)("log -> " + this.log.size()));
                Enumeration<Operation> e = this.log.elements();
                while (e.hasMoreElements()) {
                    logmon.log(BasicLevel.DEBUG, (Object)e.nextElement());
                }
            }
        }

        void writeUTF(String str) {
            int strlen = str.length();
            int newcount = this.count + strlen + 2;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(strlen >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(strlen >>> 0 & 0xFF);
            str.getBytes(0, strlen, this.buf, this.count);
            this.count = newcount;
        }

        void writeInt(int v) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[this.buf.length << 1];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count++] = (byte)(v >>> 24 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 16 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.count++] = (byte)(v >>> 0 & 0xFF);
        }
    }
}

