/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.car.impl.xml.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.metadata.car.api.ICarClassMetadata;
import org.ow2.util.ee.metadata.car.api.ICarFieldMetadata;
import org.ow2.util.ee.metadata.car.api.ICarMethodMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.xml.struct.CAR;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(CarMetadataMerge.class);
    private CarDeployableMetadata carDeployableMetadata;

    public CarMetadataMerge(CarDeployableMetadata carDeployableMetadata) {
        this.carDeployableMetadata = carDeployableMetadata;
    }

    public void merge(CAR car) {
        this.applyJndiEnvironmentRefsGroup((IEnvironment)car, this.carDeployableMetadata);
        String callbackHandler = car.getCallbackHandler();
        if (callbackHandler != null) {
            ICarClassMetadata carClassMetadata = this.getClassMetadata(callbackHandler.replace('.', '/'));
            if (carClassMetadata == null) {
                LOGGER.error((Object)("The callback handler class '" + callbackHandler + "' defined in xml was not found."), new Object[0]);
            } else {
                carClassMetadata.setCallbackHandler(true);
            }
        }
    }

    public ICarClassMetadata getClassMetadata(String className) {
        return this.carDeployableMetadata.getCarClassMetadata(className);
    }

    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        IArchiveMetadata metadata = this.carDeployableMetadata.getDeployable().getArchive().getMetadata();
        String mainClassName = metadata.get(Attributes.Name.MAIN_CLASS.toString());
        if (mainClassName == null && (mainClassName = metadata.get("main-class")) != null) {
            LOGGER.warn((Object)("The '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute is not written correctly in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'"), new Object[0]);
        }
        if (mainClassName == null) {
            throw new IllegalStateException("No '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute found in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'");
        }
        return CarMetadataMerge.encode((String)mainClassName);
    }

    protected List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(IEnvironmentRefAccessor carMetadata, String name) {
        ArrayList<IJaxwsWebServiceRef> elements = new ArrayList<IJaxwsWebServiceRef>();
        Collection<ICarClassMetadata> clientClassesMetadata = this.carDeployableMetadata.getCarClassMetadataCollection();
        if (clientClassesMetadata != null) {
            for (ICarClassMetadata classMetadata : clientClassesMetadata) {
                Collection methodMetadatas;
                Collection fieldMetadatas = classMetadata.getStandardFieldMetadataCollection();
                if (fieldMetadatas != null) {
                    for (ICarFieldMetadata fieldMetadata : fieldMetadatas) {
                        this.addJaxwsWebServiceRefIfFound((ISharedMetadata)fieldMetadata, name, elements);
                    }
                }
                if ((methodMetadatas = classMetadata.getStandardMethodMetadataCollection()) == null) continue;
                for (ICarMethodMetadata methodMetadata : methodMetadatas) {
                    this.addJaxwsWebServiceRefIfFound((ISharedMetadata)methodMetadata, name, elements);
                }
            }
        }
        return elements;
    }

    protected Collection<? extends ICommonClassMetadata> getAllClassMetadatas() {
        return this.carDeployableMetadata.getCarClassMetadataCollection();
    }

    protected Collection<? extends ICommonMethodMetadata> getAllMethodMetadatas() {
        ArrayList methodMetadatas = new ArrayList();
        Collection<ICarClassMetadata> classMetadatas = this.carDeployableMetadata.getCarClassMetadataCollection();
        for (ICommonClassMetadata iCommonClassMetadata : classMetadatas) {
            methodMetadatas.addAll(iCommonClassMetadata.getStandardMethodMetadataCollection());
        }
        return methodMetadatas;
    }

    protected Collection<? extends ICommonFieldMetadata> getAllFieldMetadatas() {
        ArrayList fieldMetadatas = new ArrayList();
        Collection<ICarClassMetadata> classMetadatas = this.carDeployableMetadata.getCarClassMetadataCollection();
        for (ICommonClassMetadata iCommonClassMetadata : classMetadatas) {
            fieldMetadatas.addAll(iCommonClassMetadata.getStandardFieldMetadataCollection());
        }
        return fieldMetadatas;
    }
}

