/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.cxf.servlet;

import javax.servlet.ServletConfig;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.ow2.jonas.camel.cxf.servlet.OsgiCxfServletTransportFactory;

public class OsgiHttpServiceCXFServlet
extends CXFNonSpringServlet {
    private final String context;

    public OsgiHttpServiceCXFServlet(String context) {
        this.context = context;
    }

    public void loadBus(ServletConfig servletConfig) {
        super.loadBus(servletConfig);
        Bus bus = this.getBus();
        ServletDestinationFactory destinationFactory = new ServletDestinationFactory();
        bus.setExtension((Object)destinationFactory, HttpDestinationFactory.class);
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        OsgiCxfServletTransportFactory df = new OsgiCxfServletTransportFactory(bus, this.context);
        try {
            this.registerTransportFactory(dfm, "http://cxf.apache.org/transports/http", (DestinationFactory)df);
            this.registerTransportFactory(dfm, "http://cxf.apache.org/transports/http/configuration", (DestinationFactory)df);
        }
        catch (BusException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void registerTransportFactory(DestinationFactoryManager dfm, String name, DestinationFactory df) throws BusException {
        DestinationFactory oldDf = dfm.getDestinationFactory(name);
        if (oldDf == null) {
            throw new IllegalStateException("CXF did not instanciate factory " + name);
        }
        dfm.deregisterDestinationFactory(name);
        dfm.registerDestinationFactory(name, df);
    }
}

