/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.impl.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.camel.registry.api.AbstractRegistryComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileRegistryComponent
extends AbstractRegistryComponent {
    private static Log logger = LogFactory.getLog(FileRegistryComponent.class);
    private Map<String, String> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(String file) throws Exception {
        HashMap<String, String> tmpRegistry = new HashMap<String, String>();
        try {
            Document doc;
            if (this.registry == null) {
                this.registry = new HashMap<String, String>();
            }
            logger.debug((Object)("Setting file: " + file));
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            if (cl.getResource(file) != null) {
                logger.debug((Object)"Loading the registy XML file from classpath");
                InputStream resource = cl.getResourceAsStream(file);
                try {
                    doc = docBuilder.parse(resource);
                }
                finally {
                    resource.close();
                    resource = null;
                }
            } else {
                logger.debug((Object)"Registy XML not in classpath, looking up as a file");
                File f = new File(file);
                if (f.isFile()) {
                    logger.debug((Object)"Loading the registy XML file from file");
                    doc = docBuilder.parse(f);
                } else {
                    logger.debug((Object)"Registy XML not a file, assuming it's a URL");
                    doc = docBuilder.parse(file);
                }
            }
            doc.getDocumentElement().normalize();
            logger.debug((Object)"Reading the registy XML file");
            NodeList listOfEntries = doc.getElementsByTagName("entry");
            for (int i = 0; i < listOfEntries.getLength(); ++i) {
                String name = null;
                String value = null;
                NodeList entry = listOfEntries.item(i).getChildNodes();
                for (int j = 0; j < entry.getLength(); ++j) {
                    Node entryDetail = entry.item(j);
                    if ("logicalName".equals(entryDetail.getNodeName())) {
                        name = this.getValueAndRemoveAllWhitespace(entryDetail);
                        continue;
                    }
                    if (!"technicalName".equals(entryDetail.getNodeName())) continue;
                    value = this.getValueAndRemoveAllWhitespace(entryDetail);
                }
                if (this.registry.containsKey(name)) {
                    throw new IllegalStateException("The entry name " + name + " is already set.");
                }
                tmpRegistry.put(name, value);
            }
            if (this.registry == null) {
                this.registry = new HashMap<String, String>();
            }
            this.registry.putAll(tmpRegistry);
            logger.debug((Object)("Registy XML loaded from: " + file));
        }
        catch (Exception e) {
            this.registry = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(InputStream input) throws Exception {
        if (this.registry == null) {
            this.registry = new HashMap<String, String>();
        }
        HashMap<String, String> tmpRegistry = new HashMap<String, String>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList listOfEntries = doc.getElementsByTagName("entry");
            for (int i = 0; i < listOfEntries.getLength(); ++i) {
                String name = null;
                String value = null;
                NodeList entry = listOfEntries.item(i).getChildNodes();
                for (int j = 0; j < entry.getLength(); ++j) {
                    Node entryDetail = entry.item(j);
                    if ("logicalName".equals(entryDetail.getNodeName())) {
                        name = this.getValueAndRemoveAllWhitespace(entryDetail);
                        continue;
                    }
                    if (!"technicalName".equals(entryDetail.getNodeName())) continue;
                    value = this.getValueAndRemoveAllWhitespace(entryDetail);
                }
                if (this.registry.containsKey(name)) {
                    throw new IllegalStateException("The entry name " + name + " is already set.");
                }
                tmpRegistry.put(name, value);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"Error while closing the inputStream", (Throwable)e);
            }
        }
        this.registry.putAll(tmpRegistry);
    }

    public void removeValues(InputStream input) {
        try {
            if (this.registry == null) {
                this.registry = new HashMap<String, String>();
            }
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList listOfEntries = doc.getElementsByTagName("entry");
            for (int i = 0; i < listOfEntries.getLength(); ++i) {
                String name = null;
                NodeList entry = listOfEntries.item(i).getChildNodes();
                for (int j = 0; j < entry.getLength(); ++j) {
                    Node entryDetail = entry.item(j);
                    if (!"logicalName".equals(entryDetail.getNodeName())) continue;
                    name = this.getValueAndRemoveAllWhitespace(entryDetail);
                }
                if (this.registry.containsKey(name)) {
                    this.registry.remove(name);
                    continue;
                }
                logger.warn((Object)"The entry {0} does not exist in the registry.");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while unregistering the entries.", e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"Error while closing the inputStream", (Throwable)e);
            }
        }
    }

    private String getValueAndRemoveAllWhitespace(Node node) {
        StringBuilder result = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            result.append(children.item(i).getNodeValue());
        }
        String value = result.toString();
        value = value.replace('\r', '\n');
        result.setLength(0);
        for (String line : value.split("\n")) {
            result.append(line.trim());
        }
        return result.toString();
    }

    protected String lookup(String name) throws Exception {
        if (this.registry == null) {
            throw new IllegalStateException("FileRegistryComponent doesn't have a valid file specified");
        }
        return this.registry.get(name);
    }
}

