/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IInstanceProvider.java 22484 2012-06-11 11:42:04Z sauthieg $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ipojo.interceptor;

import java.util.Date;
import java.util.Map;

import org.apache.felix.ipojo.architecture.InstanceDescription;

/**
 * Represents a iPOJO service provider
 * @author Jeremy Cazaux
 */
public interface IInstanceProvider {

    /**
     * @return the name of the iPOJO component
     */
    String getName();

    /**
     * @return the state of the iPOJO service
     */
    ComponentInstanceState getStateComponent();

    /**
     * @return the deployable associate to the iPOJO service
     */
    String getDeployable();

    /**
     * @return the start time of the service
     */
    Date getStartTime();

    /**
     * @return the uptime of the service
     */
    Long getUpTime();

    /**
     * @return the endtime of the service
     */
    Date getShutdownTime();

    /**
     * @return the list of {@link Throwable}
     */
    Map<Throwable, Long> getThrowables();

    /**
     * @return the 'id' of the instance
     */
    String getSource();

    /**
     * @return the {@link InstanceDescription} of the iPOJO instance managed
     */
    InstanceDescription getInstanceDescription();
}
