/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jaxrs.jersey.internal;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.ow2.jonas.jaxrs.jersey.internal.PathUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JerseyApplicationPublisher {
    private static final Log LOGGER = LogFactory.getLog(JerseyApplicationPublisher.class);
    public static final String CONTEXT_PROPERTY = "jonas.jaxrs.context-path";
    private HttpService httpService;
    private Map<ServiceReference, String> aliases = new HashMap<ServiceReference, String>();
    private RuntimeDelegate delegate;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void stop() {
        HashSet<ServiceReference> references = new HashSet<ServiceReference>(this.aliases.keySet());
        for (ServiceReference reference : references) {
            this.unregisterServletContainer(reference);
        }
    }

    public void bindApplication(Application application, ServiceReference reference) {
        String context = PathUtils.getContextPath(application, reference);
        try {
            this.httpService.registerServlet(context, (Servlet)new ServletContainer(application), null, null);
            this.aliases.put(reference, context);
            LOGGER.debug((Object)"REST Application {0} published under context ''{1}''", new Object[]{application.getClass().getName(), context});
        }
        catch (ServletException e) {
            LOGGER.error((Object)"REST Application {0} in error", new Object[]{application.getClass().getName(), e});
        }
        catch (NamespaceException e) {
            LOGGER.error((Object)"REST Application {0} is using an already bound web context name ''{}''", new Object[]{application.getClass().getName(), context, e});
        }
    }

    public void unbindApplication(ServiceReference reference) {
        this.unregisterServletContainer(reference);
    }

    private void unregisterServletContainer(ServiceReference reference) {
        String context = this.aliases.remove(reference);
        this.httpService.unregister(context);
        LOGGER.debug((Object)"Un-registered REST Application ''{0}''", new Object[]{context});
    }
}

