/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.checker.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.ow2.jonas.jndi.checker.api.IResourceChecker;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCheckerManager
implements IResourceCheckerManager {
    private static ThreadLocal<Stack<List<IResourceChecker>>> resourcesThread = new ThreadLocal<Stack<List<IResourceChecker>>>(){

        @Override
        protected Stack<List<IResourceChecker>> initialValue() {
            Stack<List<IResourceChecker>> stack = new Stack<List<IResourceChecker>>();
            ArrayList list = new ArrayList();
            stack.push(list);
            return stack;
        }
    };

    @Override
    public void push() {
        resourcesThread.get().push(new ArrayList());
    }

    @Override
    public void pop() {
        resourcesThread.get().pop();
    }

    @Override
    public void enlistResource(IResourceChecker resource) {
        if (!this.getResources().contains(resource)) {
            this.getResources().add(resource);
        }
    }

    @Override
    public void delistResource(IResourceChecker resource) {
        this.getResources().remove(resource);
    }

    @Override
    public void delistAll() {
        this.getResources().clear();
    }

    @Override
    public void detect(IResourceCheckerInfo resourceCheckerInfo) {
        List<IResourceChecker> resourceCheckers = this.getResources();
        for (IResourceChecker resourceChecker : resourceCheckers) {
            resourceChecker.detect(resourceCheckerInfo);
        }
    }

    @Override
    public List<IResourceChecker> getResources() {
        return resourcesThread.get().peek();
    }
}

