/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.management.ObjectName;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptorManager;
import org.ow2.carol.jndi.intercept.manager.SingletonInterceptorManager;
import org.ow2.easybeans.api.EZBConfigurationExtension;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.jndi.interceptors.impl.AbsContextInterceptor;
import org.ow2.jonas.jndi.interceptors.impl.Interceptors;
import org.ow2.jonas.jndi.interceptors.impl.JNDIInterceptorsComponentException;
import org.ow2.jonas.jndi.interceptors.impl.easybeans.ResourceCheckerConfigurationExtension;
import org.ow2.jonas.jndi.interceptors.impl.easybeans.ResourceCheckerInterceptor;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

public class JNDIInterceptorsComponent {
    public static final String XML_FILE = "jndi-interceptors.xml";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    private Log logger = LogFactory.getLog(JNDIInterceptorsComponent.class);
    private Interceptors interceptors = new Interceptors();
    private IResourceCheckerManager resourceCheckerManager = null;
    private InterceptorManager interceptorManager = null;
    private IEasyBeansService easybeansService = null;
    private IEventService eventService = null;
    private JmxService jmxService = null;

    public void start() throws JNDIInterceptorsComponentException {
        this.loadXML();
        this.jmxService.loadDescriptors(JNDIInterceptorsComponent.class.getPackage().getName(), this.getClass().getClassLoader());
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.jndiInterceptors((String)this.jmxService.getDomainName()));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot register service MBean", new Object[]{e});
        }
        List<ContextInterceptor> contextInterceptors = this.interceptors.getContextInterceptors();
        for (ContextInterceptor contextInterceptor : contextInterceptors) {
            this.registerContextInterceptor(contextInterceptor);
        }
        this.logger.info((Object)"JNDI Interceptors component started", new Object[0]);
    }

    protected void loadXML() throws JNDIInterceptorsComponentException {
        File xmlConfigFile = new File(JONAS_BASE + File.separator + "conf" + File.separator + XML_FILE);
        URL xmlconfigFileURL = URLUtils.fileToURL((File)xmlConfigFile);
        XMLConfiguration xmlConfiguration = new XMLConfiguration("jndi-interceptors-mapping.xml");
        xmlConfiguration.addConfigurationFile(xmlconfigFileURL);
        xmlConfiguration.setPropertyResolver((IPropertyResolver)new SystemPropertyResolver());
        HashMap<String, IResourceCheckerManager> contextualInstances = new HashMap<String, IResourceCheckerManager>();
        contextualInstances.put("RCManager", this.resourceCheckerManager);
        contextualInstances.put("jmxService", (IResourceCheckerManager)this.jmxService);
        xmlConfiguration.setContextualInstances(contextualInstances);
        try {
            xmlConfiguration.configure((Object)this);
        }
        catch (XMLConfigurationException e) {
            throw new JNDIInterceptorsComponentException("Cannot configure the Interceptor component", e);
        }
    }

    protected void registerContextInterceptor(ContextInterceptor contextInterceptor) {
        this.logger.debug((Object)"Registering the context interceptor ''{0}''", new Object[]{contextInterceptor});
        SingletonInterceptorManager.getInterceptorManager().registerContextInterceptor(contextInterceptor);
        try {
            this.jmxService.registerModelMBean((Object)contextInterceptor, this.getObjectName(contextInterceptor));
        }
        catch (Exception e) {
            this.logger.debug((Object)"Cannot register context interceptor MBean", new Object[]{e});
        }
    }

    protected void unregisterContextInterceptor(ContextInterceptor contextInterceptor) {
        this.logger.debug((Object)"Unregistering the context interceptor ''{0}''", new Object[]{contextInterceptor});
        SingletonInterceptorManager.getInterceptorManager().unregisterContextInterceptor(contextInterceptor);
        try {
            this.jmxService.unregisterModelMBean(this.getObjectName(contextInterceptor));
        }
        catch (Exception e) {
            this.logger.debug((Object)"Cannot unregister  context interceptor MBean", new Object[]{e});
        }
    }

    protected ObjectName getObjectName(ContextInterceptor contextInterceptor) {
        ObjectName tmpName;
        ObjectName oName = JonasObjectName.jndiContextInterceptor((String)this.jmxService.getDomainName(), (String)contextInterceptor.getClass().getName());
        if (contextInterceptor instanceof AbsContextInterceptor && (tmpName = ((AbsContextInterceptor)contextInterceptor).getObjectName(this.jmxService.getDomainName())) != null) {
            oName = tmpName;
        }
        return oName;
    }

    public void stop() throws JNDIInterceptorsComponentException {
        this.jmxService.unregisterModelMBean(JonasObjectName.jndiInterceptors((String)this.jmxService.getDomainName()));
        List<ContextInterceptor> contextInterceptors = this.interceptors.getContextInterceptors();
        for (ContextInterceptor contextInterceptor : contextInterceptors) {
            this.unregisterContextInterceptor(contextInterceptor);
        }
        this.logger.info((Object)"JNDI Interceptors component stopped", new Object[0]);
    }

    public Interceptors getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptors interceptors) {
        this.interceptors = interceptors;
    }

    public IResourceCheckerManager getResourceCheckerManager() {
        return this.resourceCheckerManager;
    }

    public void setResourceCheckerManager(IResourceCheckerManager resourceCheckerManager) {
        this.resourceCheckerManager = resourceCheckerManager;
    }

    public void unsetResourceCheckerManager() {
        this.resourceCheckerManager = null;
    }

    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }

    public void unsetInterceptorManager() {
        this.interceptorManager = null;
    }

    public void setEasyBeansService(IEasyBeansService easybeansService) {
        this.easybeansService = easybeansService;
        EZBServer server = easybeansService.getEasyBeansServer();
        server.getGlobalInterceptorsClasses().add(ResourceCheckerInterceptor.class);
        ResourceCheckerConfigurationExtension extension = new ResourceCheckerConfigurationExtension(this.resourceCheckerManager);
        server.getServerConfig().addExtensionFactory((EZBConfigurationExtension)extension);
    }

    public void unsetEasyBeansService() {
        this.easybeansService = null;
    }

    public void bindEventService(IEventService eventService) {
        this.eventService = eventService;
    }

    public void unbindEventService(IEventService eventService) {
        this.eventService = null;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }
}

