/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JTask;

public class JdbcRa
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[JdbcRa] ";
    private static final String JONAS_JDBCDM = "JOnAS_jdbcDM";
    private static final String RACONFIG_CLASS = "org.ow2.jonas.generators.raconfig.RAConfig";
    private static final String P6SPY_DRIVER = "com.p6spy.engine.spy.P6SpyDriver";
    private static final String REALDRIVER_PROPERTY = "realdriver";
    private String name = null;
    private String mapperName = null;
    private String user = null;
    private String password = null;
    private String url = null;
    private String driverName = null;
    private String realDriverName = null;
    private String maxPoolSize = "100";
    private String jndiName = null;
    private boolean autoload = true;
    private boolean p6spy = false;

    public void setName(String name) {
        this.name = name;
    }

    public void setMapperName(String mapperName) {
        this.mapperName = mapperName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
        this.realDriverName = driverName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    private void checkProperties() {
        if (this.name == null) {
            throw new BuildException("[JdbcRa] Property 'name' is missing.");
        }
        if (this.mapperName == null) {
            throw new BuildException("[JdbcRa] Property 'mapperName' is missing.");
        }
        if (this.user == null) {
            throw new BuildException("[JdbcRa] Property 'user' is missing.");
        }
        if (this.password == null) {
            throw new BuildException("[JdbcRa] Property 'password' is missing.");
        }
        if (this.url == null) {
            throw new BuildException("[JdbcRa] Property 'url' is missing.");
        }
        if (this.driverName == null) {
            throw new BuildException("[JdbcRa] Property 'driverName' is missing.");
        }
        if (this.jndiName == null) {
            throw new BuildException("[JdbcRa] Property 'jndiName' is missing.");
        }
    }

    private Properties getProperties() {
        this.checkProperties();
        Properties props = new Properties();
        props.put("datasource.name", this.jndiName);
        props.put("datasource.url", this.url);
        if (this.p6spy) {
            this.driverName = P6SPY_DRIVER;
        }
        props.put("datasource.classname", this.driverName);
        props.put("datasource.username", this.user);
        props.put("datasource.password", this.password);
        props.put("datasource.mapper", this.mapperName);
        props.put("jdbc.maxconpool", this.maxPoolSize);
        return props;
    }

    public void execute() {
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(new Date().getTime()));
        Properties props = this.getProperties();
        this.writePropsToFile(INFO, props, tmpFile);
        String jRootRarsDir = this.getJonasRoot().getPath() + File.separator + "rars" + File.separator + "autoload";
        String jBaseRarsDir = this.getDestDir().getPath() + File.separator + "rars";
        if (this.isAutoload()) {
            jBaseRarsDir = jBaseRarsDir + File.separator + "autoload";
        }
        String jdbcDM = jRootRarsDir + File.separator + JONAS_JDBCDM;
        String destRarFile = jBaseRarsDir + File.separator + this.name + ".rar";
        Java raConfigTask = this.getBootstraptask("");
        raConfigTask.clearArgs();
        raConfigTask.createArg().setValue(RACONFIG_CLASS);
        raConfigTask.createArg().setValue("-dm");
        raConfigTask.createArg().setValue("-p");
        raConfigTask.createArg().setValue(tmpFile.getPath());
        raConfigTask.createArg().setValue(jdbcDM);
        raConfigTask.createArg().setValue(destRarFile);
        this.log("[JdbcRa] Generating a rar file with name '" + this.name + "', mapperName '" + this.mapperName + "', user '" + this.user + "', password '" + this.password + "', URL '" + this.url + "', driverName '" + this.driverName + "' and jndiName '" + this.jndiName + "'...");
        try {
            raConfigTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            throw new BuildException("[JdbcRa] Cannot make a resource adaptor on RAConfig: ", (Throwable)rae);
        }
        finally {
            tmpFile.delete();
        }
        this.log("[JdbcRa] Rar generated : '" + destRarFile + "'.");
        if (this.p6spy) {
            String jBaseConf = this.getJonasRoot().getPath() + File.separator + "conf";
            this.changeValueForKey(INFO, jBaseConf, "spy.properties", REALDRIVER_PROPERTY, this.realDriverName, "=", false);
        }
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public void setAutoload(boolean autoload) {
        this.autoload = autoload;
    }

    public boolean isP6spy() {
        return this.p6spy;
    }

    public void setP6spy(boolean p6spy) {
        this.p6spy = p6spy;
    }
}

