/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jms.Queue;
import javax.jms.Topic;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.ActivationConfigDesc;
import org.ow2.jonas.deployment.ejb.ActivationConfigPropertyDesc;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CommonEjb;
import org.ow2.jonas.deployment.ejb.xml.JonasCommonEjb;
import org.ow2.jonas.deployment.ejb.xml.JonasMessageDriven;
import org.ow2.jonas.deployment.ejb.xml.MessageDriven;
import org.ow2.jonas.deployment.ejb.xml.MessageDrivenDestination;
import org.ow2.jonas.lib.util.BeanNaming;

public class MessageDrivenDesc
extends BeanDesc {
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int DUPS_OK_ACKNOWLEDGE = 2;
    protected static final String[] ACKMODE = new String[]{null, "AUTO_ACKNOWLEDGE", "DUPS_OK_ACKNOWLEDGE"};
    public static final int SUBS_DURABLE = 1;
    public static final int SUBS_NON_DURABLE = 2;
    protected static final String[] SUBS_DURABILITY = new String[]{null, "SUBSCRIPTION_DURABLE", "SUBSCRIPTION_NON_DURABLE"};
    public static final int DEFAULT_MAX_MESSAGES = 1;
    protected String selector = null;
    protected int acknowledgeMode;
    protected int subscriptionDurability = 2;
    protected Class destinationType = null;
    protected int txAttribute = 0;
    protected boolean isTopicDestination = false;
    protected int transactionType;
    protected String destinationJndiName = null;
    protected String destinationLink = null;
    protected String destination = null;
    protected ActivationConfigDesc mdActivationConfigDesc = null;
    protected ActivationConfigDesc mdJonasActivationConfigDesc = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MessageDrivenDesc(ClassLoader classLoader, MessageDriven md, AssemblyDescriptor asd, JonasMessageDriven jMd, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, (CommonEjb)md, (JonasCommonEjb)jMd, asd, jMDRList, fileName);
        Integer tval;
        String tstr;
        this.mdActivationConfigDesc = new ActivationConfigDesc(md.getActivationConfig());
        this.mdJonasActivationConfigDesc = new ActivationConfigDesc(jMd.getActivationConfig());
        if (jMd.getMinPoolSize() != null) {
            tstr = jMd.getMinPoolSize();
            tval = new Integer(tstr);
            this.poolMin = tval;
        }
        if (jMd.getMaxCacheSize() != null) {
            tstr = jMd.getMaxCacheSize();
            tval = new Integer(tstr);
            this.cacheMax = tval;
        }
        if (md.getEjbName() == null) {
            throw new Error("No ejb-name specified for a message-driven bean");
        }
        if (md.getTransactionType().equals("Bean")) {
            this.transactionType = 1;
        } else {
            if (!md.getTransactionType().equals("Container")) throw new DeploymentDescException("Invalid transaction-type content for ejb-name " + this.ejbName);
            this.transactionType = 2;
        }
        if (jMd.getJonasMessageDrivenDestination() != null) {
            this.destinationJndiName = jMd.getJonasMessageDrivenDestination().getJndiName();
        }
        this.selector = md.getMessageSelector();
        if (md.getAcknowledgeMode() == null) {
            this.acknowledgeMode = 1;
        } else if (md.getAcknowledgeMode().equals("Auto-acknowledge")) {
            this.acknowledgeMode = 1;
        } else {
            if (!md.getAcknowledgeMode().equals("Dups-ok-acknowledge")) throw new DeploymentDescException("Invalid acknowledge-mode content for ejb-name " + this.ejbName);
            this.acknowledgeMode = 2;
        }
        MessageDrivenDestination d = md.getMessageDrivenDestination();
        if (d != null && d.getDestinationType() != null) {
            if (d.getDestinationType().equals("javax.jms.Queue")) {
                this.destinationType = Queue.class;
            } else if (d.getDestinationType().equals("javax.jms.Topic")) {
                this.destinationType = Topic.class;
                this.isTopicDestination = true;
            } else {
                try {
                    this.destinationType = classLoader.loadClass(d.getDestinationType());
                }
                catch (Exception ex) {
                    throw new DeploymentDescException("Invalid destination-type for ejb-name " + this.ejbName);
                }
            }
            if (d.getSubscriptionDurability() != null) {
                if (this.destinationType.equals(Queue.class)) {
                    throw new DeploymentDescException("subscription-durability of message-driven-destination for ejb-name " + this.ejbName + " defined");
                }
                if (d.getSubscriptionDurability().equals("Durable")) {
                    this.subscriptionDurability = 1;
                } else {
                    if (!d.getSubscriptionDurability().equals("NonDurable")) throw new DeploymentDescException("Invalid subscription-durability content for ejb-name " + this.ejbName);
                    this.subscriptionDurability = 2;
                }
            } else if (this.destinationType.equals(Topic.class)) {
                this.subscriptionDurability = 2;
            }
        }
        this.destinationLink = md.getMessageDestinationLink();
        if (this.mdActivationConfigDesc != null) {
            this.configureAC(this.mdActivationConfigDesc, classLoader);
        }
        if (this.mdJonasActivationConfigDesc != null) {
            this.configureAC(this.mdJonasActivationConfigDesc, classLoader);
        }
        if (this.destinationJndiName == null) {
            throw new Error("No destination specified for message-driven bean " + this.ejbName);
        }
        Iterator i = this.getMethodDescIterator();
        while (i.hasNext()) {
            MethodDesc methd = (MethodDesc)i.next();
            if (methd.getMethod().getName().equals("onMessage")) {
                this.txAttribute = methd.getTxAttribute();
            }
            if (!methd.getMethod().getName().equals("ejbTimeout")) continue;
            this.timerTxAttribute = methd.getTxAttribute();
            this.ejbTimeoutSignature = BeanNaming.getSignature((String)this.getEjbName(), (Method)methd.getMethod());
        }
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public int getTxAttribute() {
        return this.txAttribute;
    }

    public boolean isBeanManagedTransaction() {
        return this.transactionType == 1;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public String getDestinationLink() {
        return this.destinationLink;
    }

    public Class getDestinationType() {
        return this.destinationType;
    }

    public boolean isTopicDestination() {
        return this.isTopicDestination;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public String getSelector() {
        return this.selector;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public int getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurability == 1;
    }

    public boolean isRequired() {
        return this.txAttribute == 2;
    }

    public int getMaxMessages() {
        return 1;
    }

    protected void checkTxAttribute(MethodDesc md) throws DeploymentDescException {
        Method m = md.getMethod();
        if (this.getTransactionType() == 2) {
            if (md.getTxAttribute() == 0) {
                logger.log(BasicLevel.WARN, (Object)("trans-attribute missing for method " + m.toString() + " in message driven bean " + this.getEjbName() + " (set to the default value " + "NotSupported" + ")"));
                md.setTxAttribute("NotSupported");
            }
            if (md.getTxAttribute() != 2 && md.getTxAttribute() != 1 && !"ejbTimeout".equals(md.getMethod().getName())) {
                throw new DeploymentDescException(md.getTxAttributeName() + " is not a valid trans-attribute for method " + m.toString() + " in message driven bean " + this.getEjbName());
            }
        } else if (md.getTxAttribute() != 0) {
            throw new DeploymentDescException("trans-attribute for message driven bean " + this.getEjbName() + " must not be defined (transaction bean managed)");
        }
    }

    public void check() throws DeploymentDescException {
        super.check();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\ngetTransactionType()=" + TRANS[this.getTransactionType()]);
        if (this.hasSelector()) {
            ret.append("\ngetSelector()=\"" + this.getSelector() + "\"");
        }
        ret.append("\ngetAcknowledgeMode()=" + ACKMODE[this.getAcknowledgeMode()]);
        if (this.getDestinationType() != null) {
            ret.append("\ngetDestinationType()=" + this.getDestinationType().getName());
        }
        ret.append("\ngetSubscriptionDurability()=" + SUBS_DURABILITY[this.getSubscriptionDurability()]);
        ret.append("\ngetDestinationJndiName()=" + this.getDestinationJndiName());
        return ret.toString();
    }

    public ActivationConfigDesc getMdActivationConfigDesc() {
        return this.mdActivationConfigDesc;
    }

    public ActivationConfigDesc getJonasMdActivationConfigDesc() {
        return this.mdJonasActivationConfigDesc;
    }

    private void configureAC(ActivationConfigDesc ac, ClassLoader curLoader) throws DeploymentDescException {
        try {
            List acpl = ac.getActivationConfigPropertyList();
            ListIterator lit = acpl.listIterator();
            while (lit.hasNext()) {
                ActivationConfigPropertyDesc el = (ActivationConfigPropertyDesc)lit.next();
                if (el.getActivationConfigPropertyName().equals("destinationType")) {
                    if (el.getActivationConfigPropertyValue().equals("javax.jms.Queue")) {
                        this.destinationType = Queue.class;
                        continue;
                    }
                    if (el.getActivationConfigPropertyValue().equals("javax.jms.Topic")) {
                        this.destinationType = Topic.class;
                        this.isTopicDestination = true;
                        continue;
                    }
                    try {
                        this.destinationType = curLoader.loadClass(el.getActivationConfigPropertyValue());
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DeploymentDescException("Invalid destination-type of " + el.getActivationConfigPropertyValue() + "for ejb-name" + this.ejbName);
                    }
                }
                if (el.getActivationConfigPropertyName().equals("messageSelector")) {
                    this.selector = el.getActivationConfigPropertyValue();
                    continue;
                }
                if (el.getActivationConfigPropertyName().equals("acknowledgeMode")) {
                    if (el.getActivationConfigPropertyValue().equals("Auto-acknowledge")) {
                        this.acknowledgeMode = 1;
                        continue;
                    }
                    if (!el.getActivationConfigPropertyValue().equals("Dups-ok-acknowledge")) continue;
                    this.acknowledgeMode = 2;
                    continue;
                }
                if (el.getActivationConfigPropertyName().equals("subscriptionDurability")) {
                    if (el.getActivationConfigPropertyValue().equals("Durable")) {
                        this.subscriptionDurability = 1;
                        continue;
                    }
                    this.subscriptionDurability = 2;
                    continue;
                }
                if (!el.getActivationConfigPropertyName().equals("destination")) continue;
                this.destination = el.getActivationConfigPropertyValue();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

