/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.ow2.jonas.ant.jonasbase.Apps;
import org.ow2.jonas.ant.jonasbase.Archives;
import org.ow2.jonas.ant.jonasbase.Ejbjars;
import org.ow2.jonas.ant.jonasbase.Rars;
import org.ow2.jonas.ant.jonasbase.Wars;

public final class JOnASAntTool {
    public static final String[] WARS_LIST = new String[]{"jonasAdmin.war"};
    public static final String[] RARS_LIST = new String[]{"jonas-jca-jdbc-cp.rar", "jonas-jca-jdbc-dm.rar", "jonas-jca-jdbc-ds.rar", "jonas-jca-jdbc-xa.rar"};
    public static final String[] EJBJARS_LIST = new String[]{""};
    public static final String[] APPS_LIST = new String[]{""};

    private JOnASAntTool() {
    }

    public static void updateJonasBase(Task antTask, File jonasRoot, File destDir) {
        Wars wars = new Wars();
        JOnASAntTool.updateJonasBaseForArchives(antTask, jonasRoot, destDir, wars, "deploy", WARS_LIST);
        Ejbjars ejbjars = new Ejbjars();
        JOnASAntTool.updateJonasBaseForArchives(antTask, jonasRoot, destDir, ejbjars, "deploy", EJBJARS_LIST);
        Rars rars = new Rars();
        JOnASAntTool.updateJonasBaseForArchives(antTask, jonasRoot, destDir, rars, "deploy", RARS_LIST);
        Apps apps = new Apps();
        JOnASAntTool.updateJonasBaseForArchives(antTask, jonasRoot, destDir, apps, "deploy", APPS_LIST);
    }

    public static void updateJonasBaseForArchives(Task antTask, File jonasRoot, File destDir, Archives archives, String folderName, String[] listOfIncludes) {
        JOnASAntTool.configure(antTask, (Task)archives);
        archives.setDestDir(destDir);
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(jonasRoot, folderName));
        for (int f = 0; f < listOfIncludes.length; ++f) {
            PatternSet.NameEntry ne = fileSet.createInclude();
            ne.setName(listOfIncludes[f]);
        }
        archives.addFileset(fileSet);
        archives.setOverwrite(true);
        String info = archives.getLogInfo();
        if (info != null) {
            antTask.log(info, 2);
        }
        archives.execute();
    }

    public static void configure(Task srcTask, Task dstTask) {
        dstTask.setTaskName(srcTask.getTaskName());
        dstTask.setProject(srcTask.getProject());
    }

    public static void deleteAllFiles(File aFile) {
        if (aFile.isDirectory()) {
            File[] someFiles = aFile.listFiles();
            for (int i = 0; i < someFiles.length; ++i) {
                JOnASAntTool.deleteAllFiles(someFiles[i]);
            }
        }
        aFile.delete();
    }

    public static Environment.Variable createVariable(String key, String value) {
        Environment.Variable variable = new Environment.Variable();
        variable.setKey(key);
        variable.setValue(value);
        return variable;
    }

    public static Environment.Variable createVariable(String key, File value) {
        Environment.Variable variable = new Environment.Variable();
        variable.setKey(key);
        variable.setFile(value);
        return variable;
    }
}

