/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JonasObjectName {
    public static ObjectName jmxConnectorServer(String protocol, String connectorName) {
        try {
            return ObjectName.getInstance("connectors:protocol=" + protocol + ",name=" + connectorName);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName serverConfig(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=management,name=reconfigManager");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName wwwService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=webContainer,name=Jetty");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName wsService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=WebService,*");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName ejbService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=ejbContainers");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName earService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=ear");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName deployableMonitorService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=depmonitor");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName mailService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=mail");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName webContainerService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=webContainers");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName databaseService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=database");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName resourceService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=resource");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName transactionService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=jtm");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName logService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=log");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName logService() {
        try {
            return ObjectName.getInstance("*:type=service,name=log");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName logBuffer(String domainName, String name) {
        try {
            return ObjectName.getInstance(domainName + ":type=LogBuffer,name=" + name);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName logBuffers(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=LogBuffer,*");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName discoveryService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=discovery");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName jmsService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=jms");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName securityService(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=security");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName jmxService() {
        try {
            return ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName war(String domainName, String filename) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=war,fname=" + JonasObjectName.fileNameForObjectName(filename));
    }

    public static ObjectName workCleaner(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=workcleaner");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName versioning(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName smartclient(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=smartclient");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName workManager(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=workmanager");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName securityMemoryFactory(String domainName, String name) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=memory,name=" + name);
    }

    public static ObjectName securityDatasourceFactory(String domainName, String name) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=datasource,name=" + name);
    }

    public static ObjectName securityLdapFactory(String domainName, String name) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=ldap,name=" + name);
    }

    public static ObjectName user(String domainName, String resource, String username) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=users,resource=" + resource + ",name=" + username);
    }

    public static ObjectName group(String domainName, String resource, String groupname) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=groups,resource=" + resource + ",name=" + groupname);
    }

    public static ObjectName role(String domainName, String resource, String rolename) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=roles,resource=" + resource + ",name=" + rolename);
    }

    public static ObjectName allWars(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=war,*");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static String getType(ObjectName obj) {
        return obj.getKeyProperty("type");
    }

    public static String fileNameForObjectName(String fileName) {
        return fileName.replace(':', '|');
    }

    public static ObjectName allSecurityFactories(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,*");
    }

    public static ObjectName allSecurityMemoryFactories(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=memory,*");
    }

    public static ObjectName allSecurityDatasourceFactories(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=datasource,*");
    }

    public static ObjectName allSecurityLdapFactories(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=securityfactory,subtype=ldap,*");
    }

    public static ObjectName allUsers(String domainName, String pResource) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=users,resource=" + pResource + ",*");
    }

    public static ObjectName allRoles(String domainName, String pResource) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=roles,resource=" + pResource + ",*");
    }

    public static ObjectName allGroups(String domainName, String pResource) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=security,subtype=groups,resource=" + pResource + ",*");
    }

    public String toString() {
        return super.toString();
    }

    public static ObjectName joramLocalServer() throws MalformedObjectNameException {
        return ObjectName.getInstance("joram:type=JMSlocalServer");
    }

    public static ObjectName joramRemoteServer(String id) throws MalformedObjectNameException {
        return ObjectName.getInstance("joram:type=JMSremoteServer,id=" + id);
    }

    public static ObjectName joramQueue(String name) throws MalformedObjectNameException {
        return ObjectName.getInstance("joram:type=JMSqueue,name=" + name);
    }

    public static ObjectName joramTopic(String name) throws MalformedObjectNameException {
        return ObjectName.getInstance("joram:type=JMStopic,name=" + name);
    }

    public static ObjectName discoveryManager(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=management,name=discoveryManager,server=JOnAS");
    }

    public static ObjectName jgroupsDiscoveryManager(String domainName, String discoveryType, String srvName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=management,name=discoveryManager" + discoveryType + ",server=" + srvName);
    }

    public static ObjectName discoveryClient(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=management,name=discoveryClient,server=JOnAS");
    }

    public static ObjectName discoveryEnroller(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=management,name=discoveryEnroller,server=JOnAS");
    }

    public static ObjectName serverProxy(String domainName, String serverName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=ServerProxy,name=" + serverName);
    }

    public static ObjectName serverProxys(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=ServerProxy,*");
    }

    public static ObjectName cluster(String domainName, String name, String type) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=" + type + ",name=" + name);
    }

    public static ObjectName clusters(String domainName, String type) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=" + type + ",*");
    }

    public static ObjectName clusterMember(String domainName, String name, String type, String cluster) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=" + type + "Member,name=" + name + "," + type + "=" + cluster);
    }

    public static ObjectName clusterDaemon(String domainName) throws Exception {
        return ObjectName.getInstance(domainName + ":type=ClusterDaemon");
    }

    public static ObjectName clusterDaemonProxy(String domainName, String name) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=ClusterDaemonProxy,name=" + name);
    }

    public static ObjectName clusterDaemonProxys(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=ClusterDaemonProxy,*");
    }

    public static ObjectName ArchiveConfig(String domainName) {
        try {
            return new ObjectName(":type=archiveConfig,name=ArchiveConfigMBean");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName RarConfig(String domainName) {
        try {
            return new ObjectName(":type=archiveConfig,name=RarConfigMBean");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName jgroupsDiscoveryCommManager(String domainName, String discoveryType, String srvName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=management,name=discoveryCommManager" + discoveryType + ",server=" + srvName);
    }

    public static ObjectName cmiClient(String domainName, String serverName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=cmi,name=CMIClient,J2EEServer=" + serverName);
    }

    public static ObjectName cmiServer(String domainName, String serverName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=cmi,name=CMIServer,J2EEServer=" + serverName);
    }

    public static ObjectName repository(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=deployment,name=repository");
    }

    public static ObjectName deploymentPlan(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=deployment,name=deploymentPlan");
    }

    public static ObjectName resourceMonitor(String domainName) throws MalformedObjectNameException {
        return ObjectName.getInstance(domainName + ":type=deployment,name=resourceMonitor");
    }
}

