/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JTask;
import org.ow2.jonas.datasource.binding.ConnectionManagerConfigurationType;
import org.ow2.jonas.datasource.binding.DatasourceConfigurationType;
import org.ow2.jonas.datasource.binding.DatasourceType;
import org.ow2.jonas.datasource.binding.Datasources;
import org.ow2.jonas.datasource.binding.ObjectFactory;
import org.ow2.jonas.datasource.reader.DatasourceXmlReader;

public class JdbcXml
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[JdbcXml] ";
    private boolean newFile = false;
    private String name = null;
    private String mapper = null;
    private String userName = null;
    private String password = null;
    private String url = null;
    private String className = null;
    private String initConPool = "1";
    private String minConPool = "10";
    private String maxConPool = "100";
    private String pstmtMax = "10";
    private String maxWaitTime = "10";
    private String maxWaiters = "100";
    private String connMaxAge = "1440";
    private String maxOpenTime = "60";
    private String conCheckLevel = "0";
    private String conTestStmt = "";
    private String samplingPeriod = "30";

    public void setClassName(String className) {
        this.className = className;
    }

    public void setInitConPool(String initConPool) {
        this.initConPool = initConPool;
    }

    public void setMinConPool(String minConPool) {
        this.minConPool = minConPool;
    }

    public void setMaxConPool(String maxConPool) {
        this.maxConPool = maxConPool;
    }

    public void setPstmtMax(String pstmtMax) {
        this.pstmtMax = pstmtMax;
    }

    public void setConCheckLevel(String conCheckLevel) {
        this.conCheckLevel = conCheckLevel;
    }

    public void setConTestStmt(String conTestStmt) {
        this.conTestStmt = conTestStmt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMapper(String mapperName) {
        this.mapper = mapperName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSamplingPeriod(String samplingPeriod) {
        this.samplingPeriod = samplingPeriod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxWaitTime(String maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setMaxWaiters(String maxWaiters) {
        this.maxWaiters = maxWaiters;
    }

    public void setConnMaxAge(String connMaxAge) {
        this.connMaxAge = connMaxAge;
    }

    public void setMaxOpenTime(String maxOpenTime) {
        this.maxOpenTime = maxOpenTime;
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public void setNewFile(String newFile) {
        this.newFile = Boolean.valueOf(newFile);
    }

    private void checkProperties() {
        if (this.name == null) {
            throw new BuildException("[JdbcXml] Property 'name' is missing.");
        }
        if (this.mapper == null) {
            throw new BuildException("[JdbcXml] Property 'mapper' is missing.");
        }
        if (this.userName == null) {
            throw new BuildException("[JdbcXml] Property 'userName' is missing.");
        }
        if (this.password == null) {
            throw new BuildException("[JdbcXml] Property 'password' is missing.");
        }
        if (this.url == null) {
            throw new BuildException("[JdbcXml] Property 'url' is missing.");
        }
        if (this.className == null) {
            throw new BuildException("[JdbcXml] Property 'className' is missing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.5")) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            this.checkProperties();
            DatasourceXmlReader datasourceReader = new DatasourceXmlReader();
            if (datasourceReader == null) {
                throw new BuildException("DatasourceReader is null");
            }
            Datasources datasources = null;
            File dsXmlFile = new File(this.getDestDir().getPath() + File.separator + "deploy" + File.separator + "jdbc-ds.xml");
            datasources = !this.isNewFile() ? datasourceReader.extractDataSources(dsXmlFile) : new Datasources();
            DatasourceType ds = new DatasourceType();
            DatasourceConfigurationType dsConf = new DatasourceConfigurationType();
            dsConf.setName(this.name);
            dsConf.setUsername(this.userName);
            dsConf.setPassword(this.password);
            dsConf.setUrl(this.url);
            dsConf.setMapper(this.mapper);
            dsConf.setClassname(this.className);
            dsConf.setDescription(this.name);
            ds.setDatasourceConfiguration(dsConf);
            ConnectionManagerConfigurationType cmConf = new ConnectionManagerConfigurationType();
            cmConf.setConnchecklevel(Integer.valueOf(this.conCheckLevel));
            cmConf.setConnteststmt(this.conTestStmt);
            cmConf.setConnmaxage(BigInteger.valueOf(Long.valueOf(this.connMaxAge)));
            cmConf.setInitconpool(BigInteger.valueOf(Long.valueOf(this.initConPool)));
            cmConf.setMinconpool(BigInteger.valueOf(Long.valueOf(this.minConPool)));
            cmConf.setMaxconpool(BigInteger.valueOf(Long.valueOf(this.maxConPool)));
            cmConf.setMaxopentime(BigInteger.valueOf(Long.valueOf(this.maxOpenTime)));
            cmConf.setMaxwaiters(BigInteger.valueOf(Long.valueOf(this.maxWaiters)));
            cmConf.setMaxwaittime(BigInteger.valueOf(Long.valueOf(this.maxWaitTime)));
            cmConf.setPstmtmax(BigInteger.valueOf(Long.valueOf(this.pstmtMax)));
            cmConf.setSamplingperiod(BigInteger.valueOf(Long.valueOf(this.samplingPeriod)));
            ds.setConnectionManagerConfiguration(cmConf);
            datasources.getDatasources().add(ds);
            if (dsXmlFile.exists()) {
                dsXmlFile.delete();
            }
            dsXmlFile.createNewFile();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            FileOutputStream fileOut = new FileOutputStream(dsXmlFile);
            try {
                marshaller.marshal((Object)datasources, (OutputStream)fileOut);
            }
            finally {
                fileOut.close();
            }
            this.log("[JdbcXml] JDBC XML generated : '" + dsXmlFile.getAbsolutePath() + "'.");
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new BuildException("Failed building JDBC XML: " + t, t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

