/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.cluster.Director;
import org.ow2.jonas.ant.cluster.ModJk;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.WebContainer;
import org.ow2.jonas.ant.jonasbase.web.Ajp;
import org.ow2.jonas.ant.jonasbase.web.Cluster;
import org.ow2.jonas.ant.jonasbase.web.Http;
import org.ow2.jonas.ant.jonasbase.web.Tomcat;

public class WebContainerCluster
extends ClusterTasks {
    private static final String INFO = "[WebContainerCluster] ";
    private String name = null;
    private String[] httpPortRange = null;
    private String[] ajpPortRange = null;
    private boolean stickySession = false;
    private boolean modjkEnabled = false;
    private String[] modJkLbFactorRange = null;
    private boolean directorEnabled = false;
    private String[] directorPortRange = null;
    private String[] directorLbFactorRange = null;
    private String clusterMcastAddr = null;
    private String clusterMcastPort = null;
    private String[] clusterListenPortRange = null;
    private String clusterName = null;
    private String modjkDir = null;
    private String modjkRootDir = null;
    private String directorDir = null;
    private String ondemandRedirectPort = null;
    private boolean ondemandEnabled = true;

    public void setDirectorDir(String directorDir) {
        this.directorDir = directorDir;
    }

    public void setModjkEnabled(boolean enabled) {
        this.modjkEnabled = enabled;
    }

    public void setDirectorEnabled(boolean enabled) {
        this.directorEnabled = enabled;
    }

    public void setModjkDir(String modjkDir) {
        this.modjkDir = modjkDir;
    }

    public void setOndemandEnabled(boolean enabled) {
        this.ondemandEnabled = enabled;
    }

    public void setOndemandRedirectPort(String redirectport) {
        this.ondemandRedirectPort = redirectport;
    }

    public void setModjkRootDir(String modjkRootDir) {
        this.modjkRootDir = modjkRootDir;
    }

    public void setClusterMcastAddr(String clusterMcastAddr) {
        this.clusterMcastAddr = clusterMcastAddr;
    }

    public void setClusterMcastPort(String clusterMcastPort) {
        this.clusterMcastPort = clusterMcastPort;
    }

    public void setClusterListenPortRange(String clusterListenPortRange) {
        this.clusterListenPortRange = clusterListenPortRange.split(",");
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setHttpPortRange(String httpPortRange) {
        this.httpPortRange = httpPortRange.split(",");
    }

    public void setAjpPortRange(String ajpPortRange) {
        this.ajpPortRange = ajpPortRange.split(",");
    }

    public void setModJkLbFactorRange(String modJkLbFactorRange) {
        this.modJkLbFactorRange = modJkLbFactorRange.split(",");
    }

    public void setDirectorPortRange(String directorPortRange) {
        this.directorPortRange = directorPortRange.split(",");
    }

    public void setDirectorLbFactorRange(String directorLbFactorRange) {
        this.directorLbFactorRange = directorLbFactorRange.split(",");
    }

    public void setName(String containerName) {
        this.name = containerName;
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    @Override
    public void generatesTasks() {
        int portInd = 0;
        ModJk modJk = new ModJk();
        Director director = new Director();
        modJk.setRootDir(this.modjkRootDir);
        modJk.setDir(this.modjkDir);
        modJk.createFiles();
        modJk.setStickySession(this.stickySession);
        director.createFile(this.directorDir);
        for (int i = this.getDestDirSuffixIndFirst(); i <= this.getDestDirSuffixIndLast(); ++i) {
            String destDir = WebContainerCluster.getDestDir(this.getDestDirPrefix(), i);
            this.log("[WebContainerCluster] tasks generation for " + destDir);
            WebContainer webContainer = new WebContainer();
            webContainer.setName(this.name);
            Tomcat tomcat = new Tomcat();
            Http http = new Http();
            http.setPort(this.httpPortRange[portInd]);
            tomcat.addConfiguredHttp(http);
            if (this.directorEnabled) {
                org.ow2.jonas.ant.jonasbase.web.Director d = new org.ow2.jonas.ant.jonasbase.web.Director();
                d.setPort(this.directorPortRange[portInd]);
                tomcat.addConfiguredDirector(d);
            }
            if (this.modjkEnabled) {
                Ajp ajp = new Ajp();
                ajp.setPort(this.ajpPortRange[portInd]);
                tomcat.addConfiguredAjp(ajp);
            }
            Cluster cluster = new Cluster();
            cluster.setListenPort(this.clusterListenPortRange[portInd]);
            cluster.setMcastAddr(this.clusterMcastAddr);
            cluster.setMcastPort(this.clusterMcastPort);
            cluster.setName(this.clusterName);
            tomcat.addConfiguredCluster(cluster);
            if (this.modjkEnabled) {
                String workerName = modJk.addWorker(this.ajpPortRange[portInd], this.modJkLbFactorRange[portInd]);
                tomcat.setJvmRoute(workerName);
            }
            webContainer.addConfiguredTomcat(tomcat);
            if (this.directorEnabled) {
                director.addAppServer(this.directorPortRange[portInd], this.directorLbFactorRange[portInd]);
            }
            if (this.ondemandEnabled) {
                webContainer.setOndemandredirectPort(this.ondemandRedirectPort);
            }
            webContainer.setOndemandenabled(Boolean.toString(this.ondemandEnabled));
            for (BaseTaskItf baseTaskItf : webContainer.getTasks()) {
                baseTaskItf.setDestDir(new File(destDir));
            }
            this.addTasks(webContainer);
            ++portInd;
        }
        if (this.modjkEnabled) {
            modJk.flushFiles();
            this.addTasks(modJk);
        }
        if (this.directorEnabled) {
            director.flushFile();
            this.addTasks(director);
        }
    }
}

