/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.deployment;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.ow2.jonas.cdi.weld.IDeploymentBuilder;
import org.ow2.jonas.cdi.weld.IWeldService;
import org.ow2.jonas.cdi.weld.internal.deployment.DefaultBeanDeploymentArchive;
import org.ow2.jonas.cdi.weld.internal.deployment.DefaultDeployment;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultDeploymentBuilder
implements IDeploymentBuilder,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(DefaultDeploymentBuilder.class);
    public static final String WEBINF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String METAINF_BEANS_XML = "META-INF/beans.xml";
    private boolean __Fmanager;
    private IArchiveManager manager;
    private boolean __Fweld;
    private IWeldService weld;
    private boolean __MsetArchiveManager$org_ow2_util_archive_api_IArchiveManager;
    private boolean __MsetWeldService$org_ow2_jonas_cdi_weld_IWeldService;
    private boolean __MbuildWebDeployment$org_ow2_util_archive_api_IArchive;

    IArchiveManager __getmanager() {
        if (!this.__Fmanager) {
            return this.manager;
        }
        return (IArchiveManager)this.__IM.onGet((Object)this, "manager");
    }

    void __setmanager(IArchiveManager iArchiveManager) {
        if (!this.__Fmanager) {
            this.manager = iArchiveManager;
            return;
        }
        this.__IM.onSet((Object)this, "manager", (Object)iArchiveManager);
    }

    IWeldService __getweld() {
        if (!this.__Fweld) {
            return this.weld;
        }
        return (IWeldService)this.__IM.onGet((Object)this, "weld");
    }

    void __setweld(IWeldService iWeldService) {
        if (!this.__Fweld) {
            this.weld = iWeldService;
            return;
        }
        this.__IM.onSet((Object)this, "weld", (Object)iWeldService);
    }

    public DefaultDeploymentBuilder() {
        this(null);
    }

    private DefaultDeploymentBuilder(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void setArchiveManager(IArchiveManager iArchiveManager) {
        if (!this.__MsetArchiveManager$org_ow2_util_archive_api_IArchiveManager) {
            this.__setArchiveManager(iArchiveManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setArchiveManager$org_ow2_util_archive_api_IArchiveManager", new Object[]{iArchiveManager});
            this.__setArchiveManager(iArchiveManager);
            this.__IM.onExit((Object)this, "setArchiveManager$org_ow2_util_archive_api_IArchiveManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setArchiveManager$org_ow2_util_archive_api_IArchiveManager", throwable);
            throw throwable;
        }
    }

    private void __setArchiveManager(IArchiveManager manager) {
        this.__setmanager(manager);
    }

    public void setWeldService(IWeldService iWeldService) {
        if (!this.__MsetWeldService$org_ow2_jonas_cdi_weld_IWeldService) {
            this.__setWeldService(iWeldService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWeldService$org_ow2_jonas_cdi_weld_IWeldService", new Object[]{iWeldService});
            this.__setWeldService(iWeldService);
            this.__IM.onExit((Object)this, "setWeldService$org_ow2_jonas_cdi_weld_IWeldService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWeldService$org_ow2_jonas_cdi_weld_IWeldService", throwable);
            throw throwable;
        }
    }

    private void __setWeldService(IWeldService weld) {
        this.__setweld(weld);
    }

    public Deployment buildWebDeployment(IArchive iArchive) {
        Deployment deployment;
        if (!this.__MbuildWebDeployment$org_ow2_util_archive_api_IArchive) {
            return this.__buildWebDeployment(iArchive);
        }
        try {
            this.__IM.onEntry((Object)this, "buildWebDeployment$org_ow2_util_archive_api_IArchive", new Object[]{iArchive});
            deployment = this.__buildWebDeployment(iArchive);
            this.__IM.onExit((Object)this, "buildWebDeployment$org_ow2_util_archive_api_IArchive", (Object)deployment);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildWebDeployment$org_ow2_util_archive_api_IArchive", throwable);
            throw throwable;
        }
        return deployment;
    }

    private Deployment __buildWebDeployment(IArchive archive) {
        logger.debug((Object)"Building Weld Deployment for {0}", new Object[]{archive});
        DefaultDeployment deployment = new DefaultDeployment();
        DefaultBeanDeploymentArchive bda = new DefaultBeanDeploymentArchive(archive.getName(), archive, deployment.getServices());
        try {
            URL beansXml = archive.getResource(WEBINF_BEANS_XML);
            bda.getBeansXml().add(beansXml);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Requires a WEB-INF/beans.xml entry.", e);
        }
        deployment.getBeanDeploymentArchives().add(bda);
        try {
            Iterator i = archive.getEntries();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
                URL webInfLibraryUrl = archive.getResource(name);
                logger.debug((Object)"Traversing library {0}", new Object[]{webInfLibraryUrl});
                IArchive archiveLibrary = this.__getmanager().getArchive((Object)webInfLibraryUrl);
                try {
                    URL beansXml = archive.getResource(METAINF_BEANS_XML);
                    bda.getBeansXml().add(beansXml);
                    DefaultBeanDeploymentArchive libraryBda = new DefaultBeanDeploymentArchive(archiveLibrary.getName(), archiveLibrary, deployment.getServices());
                    deployment.getBeanDeploymentArchives().add(libraryBda);
                }
                catch (ArchiveException e) {}
            }
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot explore archive " + archive, e);
        }
        this.__getweld().connectBeanDeploymentArchives(deployment.getBeanDeploymentArchives(), deployment.getBeanDeploymentArchives());
        return deployment;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("weld")) {
                this.__Fweld = true;
            }
            if (set.contains("manager")) {
                this.__Fmanager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setArchiveManager$org_ow2_util_archive_api_IArchiveManager")) {
                this.__MsetArchiveManager$org_ow2_util_archive_api_IArchiveManager = true;
            }
            if (set.contains("setWeldService$org_ow2_jonas_cdi_weld_IWeldService")) {
                this.__MsetWeldService$org_ow2_jonas_cdi_weld_IWeldService = true;
            }
            if (set.contains("buildWebDeployment$org_ow2_util_archive_api_IArchive")) {
                this.__MbuildWebDeployment$org_ow2_util_archive_api_IArchive = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

