/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.deployment;

import java.net.URL;
import java.util.Iterator;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.ow2.jonas.cdi.weld.IDeploymentBuilder;
import org.ow2.jonas.cdi.weld.IWeldService;
import org.ow2.jonas.cdi.weld.internal.deployment.DefaultBeanDeploymentArchive;
import org.ow2.jonas.cdi.weld.internal.deployment.DefaultDeployment;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultDeploymentBuilder
implements IDeploymentBuilder {
    private static Log logger = LogFactory.getLog(DefaultDeploymentBuilder.class);
    public static final String WEBINF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String METAINF_BEANS_XML = "META-INF/beans.xml";
    private IArchiveManager manager;
    private IWeldService weld;

    public void setArchiveManager(IArchiveManager manager) {
        this.manager = manager;
    }

    public void setWeldService(IWeldService weld) {
        this.weld = weld;
    }

    public Deployment buildWebDeployment(IArchive archive) {
        logger.debug((Object)"Building Weld Deployment for {0}", new Object[]{archive});
        DefaultDeployment deployment = new DefaultDeployment();
        DefaultBeanDeploymentArchive bda = new DefaultBeanDeploymentArchive(archive.getName(), archive, deployment.getServices());
        try {
            URL beansXml = archive.getResource(WEBINF_BEANS_XML);
            bda.getBeansXml().add(beansXml);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Requires a WEB-INF/beans.xml entry.", e);
        }
        deployment.getBeanDeploymentArchives().add(bda);
        try {
            Iterator i = archive.getEntries();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
                URL webInfLibraryUrl = archive.getResource(name);
                logger.debug((Object)"Traversing library {0}", new Object[]{webInfLibraryUrl});
                IArchive archiveLibrary = this.manager.getArchive((Object)webInfLibraryUrl);
                try {
                    URL beansXml = archive.getResource(METAINF_BEANS_XML);
                    bda.getBeansXml().add(beansXml);
                    DefaultBeanDeploymentArchive libraryBda = new DefaultBeanDeploymentArchive(archiveLibrary.getName(), archiveLibrary, deployment.getServices());
                    deployment.getBeanDeploymentArchives().add(libraryBda);
                }
                catch (ArchiveException e) {}
            }
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot explore archive " + archive, e);
        }
        this.weld.connectBeanDeploymentArchives(deployment.getBeanDeploymentArchives(), deployment.getBeanDeploymentArchives());
        return deployment;
    }
}

