/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.easybeans;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.container.EmptyResourceInjector;
import org.ow2.jonas.cdi.weld.internal.easybeans.InjectionItemHolder;
import org.ow2.jonas.cdi.weld.internal.easybeans.WeldInjectAnnotationHandler;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.IAnnotationProcessor;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WeldResourceInjector
extends EmptyResourceInjector {
    private static Log logger = LogFactory.getLog(WeldResourceInjector.class);
    WeldManager beanManager = null;
    Map<EasyBeansBean, Set<InjectionItemHolder>> injectionTargets = new HashMap<EasyBeansBean, Set<InjectionItemHolder>>();
    IAnnotationProcessor injectAnnotationProcessor;

    public void preEasyBeansInject(EasyBeansBean bean) {
        if (this.injectAnnotationProcessor != null) {
            try {
                this.injectAnnotationProcessor.process((Object)bean);
            }
            catch (ProcessorException e) {
                logger.error((Object)"Cannot inject CDI resources on bean {0}", new Object[]{bean, e});
            }
        }
    }

    public void postEasyBeansDestroy(EasyBeansBean bean) {
        Set<InjectionItemHolder> injectionTargetSet = this.injectionTargets.remove(bean);
        if (injectionTargetSet != null) {
            for (InjectionItemHolder injectionItemHolder : injectionTargetSet) {
                InjectionTarget<?> injectionTarget = injectionItemHolder.getInjectionTarget();
                Object instance = injectionItemHolder.getInstance();
                injectionTarget.preDestroy(instance);
                injectionTarget.dispose(instance);
            }
        }
    }

    public void setBeanManager(WeldManager beanManager) {
        this.beanManager = beanManager;
        this.injectAnnotationProcessor = new DefaultAnnotationProcessor();
        this.injectAnnotationProcessor.addAnnotationHandler((IAnnotationHandler)new WeldInjectAnnotationHandler(this.beanManager, this.injectionTargets));
    }
}

