/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.tomcat;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import javax.decorator.Decorator;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.tomcat7.WeldForwardingInstanceManager;
import org.jboss.weld.environment.tomcat7.WeldInstanceManager;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.servlet.ConversationPropagationFilter;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.jonas.cdi.weld.internal.bootstrap.JOnASServletDeployment;
import org.ow2.jonas.cdi.weld.internal.easybeans.EZBFactoriesRegistry;
import org.ow2.jonas.cdi.weld.internal.easybeans.WeldResourceInjector;
import org.ow2.jonas.cdi.weld.internal.ejb.EZBEjbDescriptor;
import org.ow2.jonas.cdi.weld.internal.jsf.FacesApplicationCustomizer;
import org.ow2.jonas.cdi.weld.internal.services.JOnASEjbServices;
import org.ow2.jonas.cdi.weld.internal.services.JOnASJpaInjectionServices;
import org.ow2.jonas.cdi.weld.internal.services.JOnASResourceServices;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WeldLifeCycleListener
implements LifecycleListener {
    private static Log logger = LogFactory.getLog(WeldLifeCycleListener.class);
    private WeldManager manager;
    private Bootstrap bootstrap;
    private ClassLoader webappClassLoader;
    private EZBPersistenceUnitManager persistenceUnitManager;
    private String moduleName;
    private EZBFactoriesRegistry factoriesRegistry;

    public WeldLifeCycleListener(String moduleName, EZBPersistenceUnitManager persistenceUnitManager, EZBFactoriesRegistry factoriesRegistry) {
        this.moduleName = moduleName;
        this.persistenceUnitManager = persistenceUnitManager;
        this.factoriesRegistry = factoriesRegistry;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getLifecycle() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getLifecycle();
            if ("configure_start".equals(event.getType())) {
                this.configureStart(context);
            } else if ("after_start".equals(event.getType())) {
                this.afterStart(context);
            } else if ("after_stop".equals(event.getType())) {
                this.afterStop(context);
            }
        }
    }

    private void afterStart(StandardContext context) {
        FacesApplicationCustomizer.customizeFacesApplication(this.webappClassLoader, context.getName());
    }

    private void afterStop(StandardContext context) {
        if (this.bootstrap != null) {
            logger.debug((Object)"Stop Weld container for ''{0}'' ...", new Object[]{context.getName()});
            this.bootstrap.shutdown();
        }
    }

    private void configureStart(StandardContext context) {
        InitialContext initialContext;
        logger.debug((Object)"Start Weld container for ''{0}'' ...", new Object[]{context.getName()});
        this.bootstrap = new WeldBootstrap();
        ServletContext servletContext = context.getServletContext();
        URLScanner scanner = new URLScanner(context.getLoader().getClassLoader());
        servletContext.setAttribute(URLScanner.class.getName(), (Object)scanner);
        this.webappClassLoader = context.getLoader().getClassLoader();
        JOnASServletDeployment deployment = new JOnASServletDeployment(servletContext, this.bootstrap);
        ClassLoaderResourceLoader resourceLoader = new ClassLoaderResourceLoader(this.webappClassLoader);
        deployment.getServices().add(ResourceLoader.class, (Service)resourceLoader);
        deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceLoader.class, (Service)resourceLoader);
        this.performUglyClassLoaderHack(this.webappClassLoader);
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get initial JNDI context.", new Object[]{e});
            context.setConfigured(false);
            return;
        }
        for (Factory<?, ?> factory : this.factoriesRegistry.getFactories(this.moduleName)) {
            deployment.getWebAppBeanDeploymentArchive().getEjbs().add(new EZBEjbDescriptor(deployment.getWebAppBeanDeploymentArchive(), factory));
        }
        deployment.getServices().add(EjbServices.class, (Service)new JOnASEjbServices());
        if (this.persistenceUnitManager != null) {
            deployment.getWebAppBeanDeploymentArchive().getServices().add(JpaInjectionServices.class, (Service)new JOnASJpaInjectionServices(this.persistenceUnitManager));
        }
        deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceInjectionServices.class, (Service)new JOnASResourceServices(initialContext));
        this.bootstrap.startContainer((Environment)Environments.SERVLET, (Deployment)deployment);
        this.bootstrap.startInitialization();
        this.manager = this.bootstrap.getManager((BeanDeploymentArchive)deployment.getWebAppBeanDeploymentArchive());
        servletContext.setAttribute(Listener.BEAN_MANAGER_ATTRIBUTE_NAME, (Object)this.manager);
        this.registerFilters(servletContext);
        this.configureJsp(servletContext);
        this.bindBeanManager(initialContext, context);
        this.wrapInstanceManager(context);
        this.configureWeldResourceInjector();
        this.bootstrap.deployBeans();
        this.bootstrap.validateBeans();
        this.bootstrap.endInitialization();
        this.addPreserveExceptions(servletContext);
    }

    private void addPreserveExceptions(ServletContext servletContext) {
        HashSet<Class<DefinitionException>> preserve = new HashSet<Class<DefinitionException>>();
        preserve.add(DefinitionException.class);
        Object o = servletContext.getAttribute("jonas.tomcat.load.on.startup.preserve.exceptions");
        if (o != null && o instanceof Collection && !((Collection)o).isEmpty() && ((Collection)o).iterator().next() instanceof Class) {
            Collection collection = (Collection)o;
            collection.addAll(preserve);
        } else {
            servletContext.setAttribute("jonas.tomcat.load.on.startup.preserve.exceptions", preserve);
        }
    }

    private void configureWeldResourceInjector() {
        Collection<Factory<?, ?>> factories = this.factoriesRegistry.getFactories(this.moduleName);
        if (factories.size() > 0) {
            for (ResourceInjector resourceInjector : factories.iterator().next().getContainer().getConfiguration().getInjectors()) {
                if (!(resourceInjector instanceof WeldResourceInjector)) continue;
                WeldResourceInjector injector = (WeldResourceInjector)resourceInjector;
                injector.setBeanManager(this.manager);
            }
        }
    }

    private void configureJsp(ServletContext servletContext) {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(servletContext);
            jspApplicationContext.addELResolver(this.manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
        }
    }

    private void registerFilters(ServletContext servletContext) {
        FilterRegistration.Dynamic registration = servletContext.addFilter("ConversationPropagationFilter", (Filter)new ConversationPropagationFilter());
        registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
    }

    private void wrapInstanceManager(StandardContext context) {
        InstanceManager original = context.getInstanceManager();
        WeldInstanceManager2 weldInstanceManager = new WeldInstanceManager2(this.manager);
        WeldForwardingInstanceManager forwardingInstanceManager = new WeldForwardingInstanceManager(original, weldInstanceManager);
        context.setInstanceManager((InstanceManager)forwardingInstanceManager);
        context.getServletContext().setAttribute("org.apache.tomcat.InstanceManager", (Object)forwardingInstanceManager);
    }

    private void bindBeanManager(InitialContext initialContext, StandardContext servletContext) {
        try {
            initialContext.rebind("java:comp/BeanManager", (Object)this.manager);
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to register BeanManager into JNDI.", new Object[]{e});
            servletContext.setConfigured(false);
        }
    }

    private void performUglyClassLoaderHack(ClassLoader loader) {
        try {
            loader.loadClass("org.jboss.interceptor.util.proxy.TargetInstanceProxy");
            loader.loadClass("javassist.util.proxy.ProxyObject");
            loader.loadClass(Decorator.class.getName());
            loader.loadClass(Inject.class.getName());
            loader.loadClass(Interceptor.class.getName());
            loader.loadClass(InjectionPoint.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)"Cannot load a class from {0}", new Object[]{loader, e});
        }
    }

    private static class WeldInstanceManager2
    extends WeldInstanceManager {
        public WeldInstanceManager2(WeldManager manager) {
            super(manager);
        }
    }
}

