/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWeldService.java 22454 2012-05-24 13:20:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld;

import org.ow2.util.archive.api.IArchive;

/**
 * A {@code IWeldService} is some kind of utility service that takes care of Weld related
 * operations.
 *
 * @author Guillaume Sauthier
 */
public interface IWeldService {

    /**
     * Detect if the given {@code IArchive} contains a {@code beans.xml}.
     * Checked location includes:
     * <ul>
     *   <li>{@code WEB-INF/beans.xml}</li>
     *   <li>{@code META-INF/beans.xml}</li>
     * </ul>
     * @param archive explored archive
     * @return {@code true} if the given archive is CDI enabled, {@code false} otherwise.
     */
    boolean isCdiEnabled(IArchive archive);

}
