/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASServletServices.java 19316 2010-03-02 16:24:45Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld.internal.services;

import javax.servlet.ServletContext;

import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.servlet.api.ServletServices;

/**
 * Perform a mapping from a {@code ServletContext} to a {@code BeanDeploymentArchive}.
 *
 * @author Guillaume Sauthier
 */
public class JOnASServletServices implements ServletServices {

    private BeanDeploymentArchive webArchive;

    public JOnASServletServices(BeanDeploymentArchive archive) {
        // Will works for a Web context only BDA ...
        this.webArchive = archive;
    }

    /**
     * Get the BDA for the current request. The ServletContext is provided for
     * context.
     *
     * @param ctx
     * @return
     */
    public BeanDeploymentArchive getBeanDeploymentArchive(ServletContext ctx) {
        return webArchive;
    }

    /**
     * Called by Weld when it is shutting down, allowing the service to
     * perform any cleanup needed.
     */
    public void cleanup() {
        this.webArchive = null;
    }
}
