/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.deployment;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanDeploymentArchive
implements BeanDeploymentArchive {
    private static final String WEBINF_CLASSES = "WEB-INF/classes/";
    private static final String DOT_CLASS = ".class";
    private String id;
    private Collection<BeanDeploymentArchive> accessibleBdas;
    private Collection<Class<?>> beanClasses;
    private Collection<URL> beansXmlUrls;
    private Collection<EjbDescriptor<?>> ejbDescriptors;
    private ServiceRegistry registry;
    private ResolveStatus status = ResolveStatus.UNRESOLVED;
    private IArchive archive;

    public DefaultBeanDeploymentArchive(String id, IArchive archive, ServiceRegistry registry) {
        this.id = id;
        this.archive = archive;
        this.registry = registry;
        this.accessibleBdas = new HashSet<BeanDeploymentArchive>();
        this.beanClasses = new HashSet();
        this.beansXmlUrls = new HashSet<URL>();
        this.ejbDescriptors = new HashSet();
    }

    private void resolve() {
        ResourceLoader loader = (ResourceLoader)this.registry.get(ResourceLoader.class);
        try {
            Iterator entries = this.archive.getEntries();
            while (entries.hasNext()) {
                String entry = (String)entries.next();
                if (!entry.endsWith(DOT_CLASS)) continue;
                String classname = entry.substring(0, entry.lastIndexOf(46));
                if (entry.startsWith(WEBINF_CLASSES)) {
                    classname = classname.substring(WEBINF_CLASSES.length());
                }
                classname = classname.replace('/', '.');
                this.beanClasses.add(loader.classForName(classname));
            }
            this.status = ResolveStatus.RESOLVED;
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Unable to get resource from archive " + this.archive, e);
        }
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.accessibleBdas;
    }

    public Collection<Class<?>> getBeanClasses() {
        if (ResolveStatus.UNRESOLVED.equals((Object)this.status)) {
            this.resolve();
        }
        return this.beanClasses;
    }

    public Collection<URL> getBeansXml() {
        return this.beansXmlUrls;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescriptors;
    }

    public ServiceRegistry getServices() {
        return this.registry;
    }

    public String getId() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResolveStatus {
        UNRESOLVED,
        RESOLVED;

    }
}

