/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal;

import java.net.URL;
import java.util.Collection;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.ow2.jonas.cdi.weld.IWeldService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWeldService
extends AbsServiceImpl
implements IWeldService {
    protected void doStart() throws ServiceException {
    }

    protected void doStop() throws ServiceException {
    }

    @Override
    public boolean isCdiEnabled(IArchive archive) {
        try {
            URL resource = archive.getResource("META-INF/beans.xml");
            if (resource != null) {
                return true;
            }
            resource = archive.getResource("WEB-INF/beans.xml");
            if (resource != null) {
                return true;
            }
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void connectBeanDeploymentArchives(Collection<BeanDeploymentArchive> childs, Collection<BeanDeploymentArchive> parents) {
        for (BeanDeploymentArchive parent : parents) {
            for (BeanDeploymentArchive child : childs) {
                if (parent.equals(child)) continue;
                child.getBeanDeploymentArchives().add(parent);
            }
        }
    }

    @Override
    public Bootstrap startWeldContainer(Deployment deployment) {
        ConcurrentHashMapBeanStore beanStore = new ConcurrentHashMapBeanStore();
        WeldBootstrap boot = new WeldBootstrap();
        boot.startContainer((Environment)Environments.SERVLET, deployment, (BeanStore)beanStore);
        boot.startInitialization();
        boot.deployBeans();
        boot.validateBeans();
        boot.endInitialization();
        return boot;
    }
}

