/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.tomcat;

import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.servlet.WeldListener;
import org.jboss.weld.servlet.api.ServletServices;
import org.ow2.jonas.cdi.weld.IDeploymentBuilder;
import org.ow2.jonas.cdi.weld.IWeldService;
import org.ow2.jonas.cdi.weld.internal.WeldDeployableInfo;
import org.ow2.jonas.cdi.weld.internal.services.JOnASServletServices;
import org.ow2.jonas.cdi.weld.internal.tomcat.WeldLifeCycleListener;
import org.ow2.jonas.web.tomcat6.custom.ContextCustomizer;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;

public class WeldContextCustomizer
implements ContextCustomizer {
    private IWeldService weld;
    private IDeploymentBuilder builder;

    public void setWeldService(IWeldService weld) {
        this.weld = weld;
    }

    public void setDeploymentBuilder(IDeploymentBuilder builder) {
        this.builder = builder;
    }

    public void customize(StandardContext context, WARDeployable deployable) {
        if (deployable == null) {
            return;
        }
        if (this.weld.isCdiEnabled(deployable.getArchive())) {
            WeldDeployableInfo info = (WeldDeployableInfo)deployable.getExtension(WeldDeployableInfo.class);
            if (info == null) {
                info = new WeldDeployableInfo();
                deployable.addExtension((IDeployableInfo)info);
                Deployment deployment = this.builder.buildWebDeployment(deployable.getArchive());
                BeanDeploymentArchive main = (BeanDeploymentArchive)deployment.getBeanDeploymentArchives().iterator().next();
                deployment.getServices().add(ServletServices.class, (Service)new JOnASServletServices(main));
                WeldLifeCycleListener listener = new WeldLifeCycleListener(this.weld, deployment, info);
                context.addLifecycleListener((LifecycleListener)listener);
            }
            context.addApplicationListener(WeldListener.class.getName());
        }
    }
}

