/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.tomcat;

import java.lang.reflect.InvocationTargetException;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.tomcat.ForwardingAnnotationProcessor;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.ow2.jonas.cdi.weld.IWeldService;
import org.ow2.jonas.cdi.weld.internal.WeldDeployableInfo;
import org.ow2.jonas.cdi.weld.internal.resource.ApplicationResourceLoader;
import org.ow2.jonas.cdi.weld.internal.standard.CDIAnnotationProcessor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WeldLifeCycleListener
implements LifecycleListener {
    private static Log logger = LogFactory.getLog(WeldLifeCycleListener.class);
    private WeldDeployableInfo info;
    private IWeldService weld;
    private Deployment deployment;
    private BeanManager manager;

    public WeldLifeCycleListener(IWeldService weld, Deployment deployment, WeldDeployableInfo info) {
        this.weld = weld;
        this.deployment = deployment;
        this.info = info;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getLifecycle() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getLifecycle();
            if ("start".equals(event.getType())) {
                this.start(context);
            } else if ("after_start".equals(event.getType())) {
                this.afterStart(context);
            } else if ("after_stop".equals(event.getType())) {
                this.afterStop(context);
            }
        }
    }

    private void afterStop(StandardContext context) {
        if (this.info.getBootstrap() != null) {
            logger.debug((Object)"Stop Weld container for ''{0}'' ...", new Object[]{context.getName()});
            this.info.getBootstrap().shutdown();
            this.info.setBootstrap(null);
        }
    }

    private void start(StandardContext context) {
        logger.debug((Object)"Start Weld container for ''{0}'' ...", new Object[]{context.getName()});
        ClassLoader webAppLoader = context.getLoader().getClassLoader();
        ApplicationResourceLoader resourceLoader = new ApplicationResourceLoader(webAppLoader);
        this.deployment.getServices().add(ResourceLoader.class, (Service)resourceLoader);
        this.performUglyClassLoaderHack(webAppLoader);
        Bootstrap boot = this.weld.startWeldContainer(this.deployment);
        BeanDeploymentArchive main = (BeanDeploymentArchive)this.deployment.getBeanDeploymentArchives().iterator().next();
        this.manager = boot.getManager(main);
        this.info.setBootstrap(boot);
    }

    private void afterStart(StandardContext context) {
        final AnnotationProcessor original = context.getAnnotationProcessor();
        final CDIAnnotationProcessor cdiAnnotationProcessor = new CDIAnnotationProcessor(this.manager);
        ForwardingAnnotationProcessor processor = new ForwardingAnnotationProcessor(){

            protected AnnotationProcessor delegate() {
                return original;
            }

            public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
                super.processAnnotations(instance);
                cdiAnnotationProcessor.processAnnotations(instance);
            }
        };
        context.setAnnotationProcessor((AnnotationProcessor)processor);
    }

    private void performUglyClassLoaderHack(ClassLoader loader) {
        try {
            loader.loadClass("org.jboss.interceptor.util.proxy.TargetInstanceProxy");
            loader.loadClass("javassist.util.proxy.ProxyObject");
            loader.loadClass(Decorator.class.getName());
            loader.loadClass(Inject.class.getName());
            loader.loadClass(Interceptor.class.getName());
            loader.loadClass(InjectionPoint.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)"Cannot load a class from {0}", new Object[]{loader, e});
        }
    }
}

