/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.ejb.EJBObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.component.event.EventComponent;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.IServerConfig;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.osgi.ILoadBalancingService;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.cmi.internal.CmiServicePolicyStrategyManager;
import org.ow2.jonas.cmi.internal.CmiServiceProperty;
import org.ow2.jonas.cmi.internal.LoadBalancingListener;
import org.ow2.jonas.cmi.internal.event.BeanEventListener;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.component.api.Component;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServiceImpl
extends AbsServiceImpl
implements CmiService {
    private static Logger cmilogger = Log.getLogger((String)"org.ow2.jonas.cmi");
    private JmxService jmxService = null;
    private final BundleContext context;
    private static ClusterViewManager clusterViewManager;
    private ServiceRegistration clusterViewManagerRegistration;
    private IEventService eventService = null;
    private CmiServicePolicyStrategyManager policyStrategyManager = null;
    private LoadBalancingListener listener;
    IEventListener beanEventListener = null;

    public CmiServiceImpl(BundleContext context) {
        this.context = context;
    }

    protected void doStart() throws ServiceException {
        URL cmiConfUrl;
        File deployDirectory = new File(JProp.getJonasBase(), CmiServiceProperty.DEFAULT_DEPLOY_DIRECTORY.getPropertyName());
        try {
            File cmiConf = new File(JProp.getConfDir(), "cmi-config.xml");
            if (!cmiConf.exists()) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Missing file 'cmi-config.xml' in JONAS_BASE : " + JProp.getConfDir()));
                throw new ServiceException("Missing file 'cmi-config.xml' in JONAS_BASE : " + JProp.getConfDir());
            }
            cmiConfUrl = cmiConf.toURI().toURL();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot configure Carol to use CMI", (Throwable)e);
            throw new ServiceException("Cannot configure Carol to use CMI", (Throwable)e);
        }
        final ClusterViewManagerFactory clusterViewManagerFactory = ClusterViewManagerFactory.getFactory();
        IExecution<Boolean> startExec = new IExecution<Boolean>(){

            public Boolean execute() throws Exception {
                ConfigurationRepository.getServerConfiguration().enableCMI(cmiConfUrl);
                clusterViewManager = clusterViewManagerFactory.create();
                if (CmiServiceImpl.this.eventService != null) {
                    List components = clusterViewManagerFactory.getConfig().getComponents().getComponents();
                    if (components != null) {
                        for (Component eventComponent : components) {
                            if (!EventComponent.class.isAssignableFrom(eventComponent.getClass())) continue;
                            ((EventComponent)eventComponent).setEventService(CmiServiceImpl.this.eventService);
                        }
                    }
                    CmiServiceImpl.this.beanEventListener = new BeanEventListener();
                    CmiServiceImpl.this.eventService.registerListener(CmiServiceImpl.this.beanEventListener, ((BeanEventListener)CmiServiceImpl.this.beanEventListener).getEventProviderFilter());
                }
                return clusterViewManager.start();
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            try {
                ConfigurationRepository.getServerConfiguration().disableCMI();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.WARN, (Object)"Cannot disable cmi in Carol", (Throwable)e);
            }
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot start the server-side manager", (Throwable)startExecResult.getException());
            throw new ServiceException("Cannot start the CMI server", (Throwable)startExecResult.getException());
        }
        if (deployDirectory.exists()) {
            cmilogger.log(BasicLevel.DEBUG, (Object)("Deploy directory of CMI service is: " + deployDirectory.getAbsolutePath()));
            try {
                IServerConfig srvConfig = (IServerConfig)clusterViewManager.getConfig();
                srvConfig.setDeployDirectory(deployDirectory.getAbsolutePath());
            }
            catch (ClassCastException e) {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Set deploy directory only if CMI is server");
            }
            catch (Exception e1) {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Cannot set deploy directory", (Throwable)e1);
            }
        } else {
            cmilogger.log(BasicLevel.DEBUG, (Object)"No deploy directory for CMI service");
        }
        this.clusterViewManagerRegistration = this.context.registerService(ClusterViewManager.class.getName(), (Object)clusterViewManager, null);
        if (clusterViewManager instanceof ServerClusterViewManager) {
            this.policyStrategyManager = new CmiServicePolicyStrategyManager((ServerClusterViewManager)clusterViewManager);
            this.listener = new LoadBalancingListener(this.policyStrategyManager);
            cmilogger.log(BasicLevel.DEBUG, (Object)"Adding listener for load balancing service ");
            try {
                this.context.addServiceListener((ServiceListener)this.listener, "(objectClass=" + ILoadBalancingService.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                cmilogger.log(BasicLevel.WARN, (Object)("Unable to add service listener for " + ILoadBalancingService.class.getName() + " because: " + (Object)((Object)e)));
            }
        }
    }

    protected void doStop() throws ServiceException {
        if (this.listener != null) {
            this.context.removeServiceListener((ServiceListener)this.listener);
        }
        if (this.clusterViewManagerRegistration != null) {
            this.clusterViewManagerRegistration.unregister();
        }
        try {
            ConfigurationRepository.getServerConfiguration().disableCMI();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.WARN, (Object)"Cannot disable cmi in Carol", (Throwable)e);
        }
        if (clusterViewManager != null) {
            try {
                ((AbsServerClusterViewManager)clusterViewManager).stop();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)"Cannot stop the server-side manager", (Throwable)e);
                throw new ServiceException("Cannot stop the server-side manager", (Throwable)e);
            }
        }
    }

    protected JmxService getJmxService() {
        return this.jmxService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setEventService(IEventService eventService) {
        this.eventService = eventService;
    }

    public void addClusteredObject(String jndiName, Object clusterConfig, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Adding clustered object named: " + jndiName));
        ((BeanEventListener)this.beanEventListener).addClusteredObject(jndiName, clusterConfig, homeClass, remoteClass, classLoader, stateful, clusterReplicated);
    }

    public void removeClusteredObject(String jndiName) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Removing clustered object named :" + jndiName));
        ((BeanEventListener)this.beanEventListener).removeClusteredObject(jndiName, (ServerClusterViewManager)clusterViewManager);
    }

    public IEventListener getBeanEventListener() {
        return this.beanEventListener;
    }

    public void setBeanEventListener(IEventListener beanEventListener) {
        this.beanEventListener = beanEventListener;
    }

    public static synchronized ClusterViewManager getClusterViewManager() {
        return clusterViewManager;
    }
}

