/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id:BaseDiscovery.java 10967 2007-07-12 07:50:01Z eyindanga $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.discovery.base;

import java.util.ArrayList;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import org.ow2.jonas.discovery.DiscoveryService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;

/**
 * This class is inherited by all discovery Implementations It provides common discovery operations.
 * @author  eyindanga
 */

public abstract class BaseDiscovery extends AbsServiceImpl implements DiscoveryService , DiscoveryServiceImplMBean {

    /**
     * This attribute is injected
     * The time period in miliseconds to listen for greeting responses.
     * @uml.property  name="greetingAckTimeOut"
     */
    protected int greetingAckTimeOut;
    /**
     * This attribute is injected
     * TimeToLive value.
     */
    protected static final int DISCOVERY_TTL_DEFAULT = 1;
    /**
     * This attribute is injected
     * TimeToLive default value
     * @uml.property  name="ttl"
     */
    protected int ttl = DISCOVERY_TTL_DEFAULT;

    /**
     * This attribute is injected
     * set to true if enroller and discoveryClient started.
     * @uml.property  name="isDiscoveryMaster"
     */
    protected boolean isDiscoveryMaster = false;
    /**
     * This attribute is injected
     */
    protected JmxService jmxService =  null;
    /**
     * Array list of urls retrived from jmxService.
     */
    protected ArrayList urlsList;

    /**
     * @return  the greetingAckTimeOut
     * @uml.property  name="greetingAckTimeOut"
     */
    public abstract int getGreetingTimeout();

    /**
     * @return  the isDiscoveryMaster
     * @uml.property  name="isDiscoveryMaster"
     */
    public abstract boolean isDiscoveryMaster();
    /**
     * @return  the listeningIp
     * @uml.property  name="listeningIp"
     */
    public abstract String getListeningIp();
    /**
     * @param listeningIp  the listeningIp to set
     * @uml.property  name="listeningIp"
     */
    public abstract void setListeningIp(final String listeningIp);
    /**
     * @return  the listeningPort
     * @uml.property  name="listeningPort"
     */
    public abstract int getListeningPort();
    /**
     * @param listeningPort  the listeningPort to set
     * @uml.property  name="listeningPort"
     */
    public abstract void setListeningPort(final int listeningPort);

    /**
     * @return  the ttl
     * @uml.property  name="ttl"
     */
    public abstract int getTtl();
    /**
     * @param ttl  the ttl to set
     * @uml.property  name="ttl"
     */
    public abstract void setTtl(final int ttl);
    /**
     * @return the jmxService
     */
    public abstract JmxService getJmxService();

    /**
     * Sets the jmxService.
     * @param jmxService the jmxService to set. Used by the injector
     */
    public abstract void setJmxService(final JmxService jmxService);

    /**
     * @return the urlsList
     */
    public abstract ArrayList getUrlsList();

    /**
     * @param urlsList the urlsList to set
     */
    public abstract void setUrlsList(final ArrayList urlsList);
    /**
     * @param isDiscoveryMaster the isDiscoveryMaster to set
     */
    public abstract void setMaster(final boolean isDiscoveryMaster);

}
